import 'dart:io';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:get/get.dart';

Future<bool> onPopScope(BuildContext context) async {
  // Check if there's already an open dialog
  if (Get.isDialogOpen == true) {
    return false; // Do nothing if a dialog is already open
  }

  // Show confirmation dialog using Get.dialog
  return (await Get.dialog(
        AlertDialog(
          shape:
              RoundedRectangleBorder(borderRadius: BorderRadius.circular(16.r)),
          title: const Text('Exit App'),
          content: const Text('Are you sure you want to exit?'),
          actions: [
            TextButton(
              onPressed: () =>
                  Get.back(result: false), // Use Get.back for consistency
              child: const Text('No'),
            ),
            TextButton(
              onPressed: () {
                if (Platform.isAndroid) {
                  SystemNavigator.pop(); // Close the app on Android
                } else if (Platform.isIOS) {
                  exit(0); // Close the app on iOS
                }
              },
              child: const Text('Yes'),
            ),
          ],
        ),
      )) ??
      false; // Return false if dialog was dismissed
}
