import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_staggered_grid_view/flutter_staggered_grid_view.dart';
import 'package:flutter_svg/svg.dart';
import 'package:foodking/app/modules/home/controllers/home_controller.dart';
import 'package:get/get.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';
import '../app/modules/address/controllers/address_controller.dart';
import '../app/modules/address/widget/location_dialouge.dart';
import '../main.dart';
import '../util/constant.dart';
import '../util/style.dart';
import 'popscope_dialog.dart';

final formKey = GlobalKey<FormState>();

openInitalAddressDialog({
  required BuildContext context,
  GoogleMapController? googleMapController,
  CameraPosition? camPosition,
  HomeController? homeController,
}) {
  Get.dialog(
      barrierDismissible: false,
      PopScope(
        canPop: false,
        onPopInvokedWithResult: (_, dynamic) async => await onPopScope(context),
        child: Padding(
          padding: EdgeInsets.symmetric(horizontal: 8.w),
          child: Dialog(
              insetPadding: EdgeInsets.zero,
              backgroundColor: Colors.transparent,
              child: GetBuilder<AddressController>(
                builder: (addressController) => SingleChildScrollView(
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      Container(
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.only(
                              topLeft: Radius.circular(16.r),
                              topRight: Radius.circular(16.r),
                              bottomLeft: Radius.circular(16.r),
                              bottomRight: Radius.circular(16.r)),
                          color: Colors.white,
                          boxShadow: [
                            BoxShadow(
                              color: AppColor.gray.withOpacity(0.5),
                              offset: const Offset(
                                0.0,
                                6.0,
                              ),
                              blurRadius: 30.r,
                              spreadRadius: 10.r,
                            ),
                          ],
                        ),
                        child: Padding(
                          padding: const EdgeInsets.only(
                              left: 16, right: 16, bottom: 16),
                          child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                SizedBox(height: 16.h),
                                Row(
                                  mainAxisAlignment:
                                      MainAxisAlignment.spaceBetween,
                                  children: [
                                    Text(
                                      "DELIVERY_ADDRESS".tr,
                                      style: fontMedium,
                                    ),
                                    homeController!.showCloseIcon
                                        ? GestureDetector(
                                            onTap: () {
                                              addressController
                                                  .addressTypeIndex = -1;
                                              addressController
                                                  .initialAddressIndex = -1;
                                              addressController
                                                  .selectedAddressType = "";

                                              Get.back();
                                            },
                                            child: SvgPicture.asset(
                                              Images.IconClose,
                                              height: 24.h,
                                            ),
                                          )
                                        : const SizedBox()
                                  ],
                                ),
                                SizedBox(height: 20.h),
                                const Divider(),
                                SizedBox(height: 24.h),

                                /*--------[START - Search Location ]--------*/

                                Container(
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(16.r),
                                    border: Border.all(color: AppColor.bgColor),
                                  ),
                                  child: Row(
                                    children: [
                                      ConstrainedBox(
                                        constraints:
                                            BoxConstraints(maxWidth: 312.w),
                                        child: SizedBox(
                                          height: 48.h,
                                          width: double.infinity,
                                          child: Stack(
                                            children: [
                                              InkWell(
                                                onTap: () => Get.dialog(
                                                    LocationSearchDialog(
                                                        mapController:
                                                            googleMapController)),
                                                child: Container(
                                                  height: 48.h,
                                                  padding: EdgeInsets.symmetric(
                                                      horizontal: 10.h),
                                                  decoration: BoxDecoration(
                                                    color: Theme.of(context)
                                                        .cardColor,
                                                    borderRadius: box.read(
                                                                'languageCode') ==
                                                            'ar'
                                                        ? BorderRadius.only(
                                                            topLeft:
                                                                Radius.circular(
                                                                    16.r),
                                                            bottomLeft:
                                                                Radius.circular(
                                                                    16.r))
                                                        : BorderRadius.only(
                                                            topRight:
                                                                Radius.circular(
                                                                    16.r),
                                                            bottomRight:
                                                                Radius.circular(
                                                                    16.r),
                                                          ),
                                                  ),
                                                  child: Row(children: [
                                                    Icon(Icons.search,
                                                        size: 25.h,
                                                        color: Colors.grey),
                                                    SizedBox(width: 10.h),
                                                    Expanded(
                                                      child: Text(
                                                        "SEARCH_LOCATION".tr,
                                                        maxLines: 1,
                                                        overflow: TextOverflow
                                                            .ellipsis,
                                                      ),
                                                    ),
                                                    SizedBox(width: 10.h),

                                                    // end icon here
                                                  ]),
                                                ),
                                              ),
                                              Positioned(
                                                top: 6.h,
                                                right: 8.w,
                                                bottom: 6.h,
                                                child: InkWell(
                                                  onTap: () {
                                                    if (googleMapController !=
                                                        null) {
                                                      addressController
                                                          .getCurrentLocationWhenTapped(
                                                              googleMapController);
                                                    } else {
                                                      // Handle case where the controller is not yet initialized
                                                      print(
                                                          "Google Map Controller is not initialized");
                                                    }
                                                  },
                                                  child: Container(
                                                    height: 36.h,
                                                    width: 32.w,
                                                    decoration: BoxDecoration(
                                                        borderRadius:
                                                            BorderRadius
                                                                .circular(8.r),
                                                        color: AppColor
                                                            .primaryColor),
                                                    child: const Icon(
                                                        Icons.my_location,
                                                        color: Colors.white),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),

                                /*--------[END - Search Location]--------*/

                                SizedBox(height: 24.h),

                                /*--------[Start - Google Map]--------*/

                                Container(
                                  height: 200.h,
                                  decoration: BoxDecoration(
                                      borderRadius:
                                          BorderRadius.circular(16.r)),
                                  child: GetBuilder<AddressController>(
                                    builder: (controller) => ClipRRect(
                                      borderRadius: BorderRadius.circular(16.r),
                                      child: Stack(
                                        children: [
                                          GoogleMap(
                                            markers: addressController.markers,

                                            initialCameraPosition:
                                                CameraPosition(
                                                    target: controller
                                                                .pickPosition
                                                                .latitude !=
                                                            0
                                                        ? LatLng(
                                                            controller
                                                                .pickPosition
                                                                .latitude,
                                                            controller
                                                                .pickPosition
                                                                .longitude)
                                                        : LatLng(
                                                            controller
                                                                .pickPosition
                                                                .latitude,
                                                            controller
                                                                .pickPosition
                                                                .longitude),
                                                    zoom: 17),
                                            zoomControlsEnabled: false,
                                            myLocationEnabled: false,
                                            compassEnabled: false,
                                            indoorViewEnabled: true,
                                            mapToolbarEnabled: true,
                                            minMaxZoomPreference:
                                                const MinMaxZoomPreference(
                                                    0, 16),
                                            onMapCreated: (GoogleMapController
                                                controller) {
                                              googleMapController = controller;
                                              addressController
                                                  .getCurrentLocation();
                                            },
                                            onCameraMove: (CameraPosition
                                                cameraPosition) {
                                              cameraPosition = cameraPosition;
                                              controller.updatePosition(
                                                  cameraPosition);
                                            },
                                            onTap: (latLong) async {
                                              addressController.picketLat =
                                                  latLong.latitude;
                                              addressController.picketLong =
                                                  latLong.longitude;
                                              await addressController
                                                  .getPlaceName(
                                                      latLong.latitude,
                                                      latLong.longitude);

                                              addressController
                                                  .addMarker(latLong);

                                              print(
                                                  "PickLat = ${addressController.picketLat}");
                                              print(
                                                  "PickLong = ${addressController.picketLong}");
                                            },
                                            // onCameraIdle: () {
                                            //   controller.updatePosition(_cameraPosition!);
                                            // },
                                          ),
                                          Center(
                                            child: controller.markerLoader
                                                ? const CircularProgressIndicator(
                                                    color:
                                                        AppColor.primaryColor)
                                                : const SizedBox(),
                                          )
                                        ],
                                      ),
                                    ),
                                  ),
                                ),

                                /*--------[End - Google Map]--------*/

                                Padding(
                                  padding: EdgeInsets.symmetric(vertical: 16.h),
                                  child: Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    children: [
                                      SizedBox(
                                        height: 24.h,
                                        width: 24.w,
                                        child: SvgPicture.asset(
                                          Images.locationIcon,
                                          fit: BoxFit.cover,
                                        ),
                                      ),
                                      SizedBox(
                                        width: 10.w,
                                      ),
                                      InkWell(
                                        child: SizedBox(
                                          height: 50.h,
                                          width: 280.w,
                                          child: Obx(
                                            () => Text(
                                              addressController
                                                  .pickAdressLocation.value
                                                  .toString(),
                                              style: TextStyle(
                                                fontFamily: 'Rubik',
                                                fontWeight: FontWeight.w400,
                                                fontSize: 14.sp,
                                              ),
                                              maxLines: 2,
                                              overflow: TextOverflow.ellipsis,
                                            ),
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),

                                /*--------[START - APPARTMENT & Flat Not]--------*/

                                Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Text(
                                      "APPARTMENT_&_FLAT_NO".tr,
                                      style: fontRegular,
                                    ),
                                    SizedBox(
                                      height: 4.h,
                                    ),
                                    SizedBox(
                                      child: TextField(
                                        showCursor: true,
                                        readOnly: false,
                                        controller: addressController
                                            .apartmentController,
                                        expands: false,
                                        decoration: InputDecoration(
                                          fillColor: AppColor.searchBarbg,
                                          focusedBorder: OutlineInputBorder(
                                            borderRadius: BorderRadius.all(
                                                Radius.circular(12.0.r)),
                                            borderSide: BorderSide(
                                                color: AppColor.searchBarbg,
                                                width: 2.0.w),
                                          ),
                                          enabledBorder: OutlineInputBorder(
                                            borderRadius: BorderRadius.all(
                                                Radius.circular(12.0.r)),
                                            borderSide: BorderSide(
                                                width: 2.w,
                                                color: AppColor.dividerColor),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ),

                                /*--------[End - APPARTMENT & Flat No]--------*/
                                SizedBox(
                                  height: 16.h,
                                ),

                                /*--------[START - ADD LABEL]--------*/
                                box.read('isLogedIn')
                                    ? Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Text(
                                            "ADD_LABEL".tr,
                                            style: fontMedium,
                                          ),
                                          SizedBox(
                                            height: 9.h,
                                          ),
                                          SizedBox(
                                            height: 50.h,
                                            child: ListView.builder(
                                                shrinkWrap: true,
                                                scrollDirection:
                                                    Axis.horizontal,
                                                itemCount: addressController
                                                    .addressTypeList.length,
                                                itemBuilder:
                                                    (BuildContext context,
                                                        index) {
                                                  return Padding(
                                                    padding:
                                                        const EdgeInsets.only(
                                                            right: 10),
                                                    child: InkWell(
                                                      onTap: () {
                                                        addressController
                                                            .initialAddressIndex = -1;
                                                        addressController
                                                            .setAddressTypeIndex(
                                                                index);
                                                      },
                                                      child: Column(
                                                        children: [
                                                          Container(
                                                            height: 48.h,
                                                            width: 88.w,
                                                            decoration:
                                                                BoxDecoration(
                                                              borderRadius:
                                                                  BorderRadius
                                                                      .circular(
                                                                          8.r),
                                                              color: addressController
                                                                          .addressTypeIndex ==
                                                                      index
                                                                  ? AppColor
                                                                      .primaryColor
                                                                      .withOpacity(
                                                                          0.08)
                                                                  : AppColor
                                                                      .itembg,
                                                              border: addressController
                                                                          .addressTypeIndex ==
                                                                      index
                                                                  ? Border.all(
                                                                      color: AppColor
                                                                          .primaryColor)
                                                                  : Border.all(
                                                                      color: Colors
                                                                          .white),
                                                            ),
                                                            child: Row(
                                                              crossAxisAlignment:
                                                                  CrossAxisAlignment
                                                                      .center,
                                                              mainAxisAlignment:
                                                                  MainAxisAlignment
                                                                      .center,
                                                              children: [
                                                                addressController
                                                                            .addressTypeList[
                                                                                index]
                                                                            .toString() ==
                                                                        "Home"
                                                                    ? SvgPicture
                                                                        .asset(
                                                                        Images
                                                                            .homeIcon,
                                                                        fit: BoxFit
                                                                            .cover,
                                                                        height:
                                                                            15.h,
                                                                        width:
                                                                            15.w,
                                                                        color: addressController.addressTypeIndex ==
                                                                                index
                                                                            ? null
                                                                            : AppColor.gray,
                                                                      )
                                                                    : addressController.addressTypeList[index].toString() ==
                                                                            "Work"
                                                                        ? SvgPicture
                                                                            .asset(
                                                                            Images.work,
                                                                            fit:
                                                                                BoxFit.cover,
                                                                            color: addressController.addressTypeIndex == index
                                                                                ? null
                                                                                : AppColor.gray,
                                                                          )
                                                                        : SvgPicture
                                                                            .asset(
                                                                            Images.other,
                                                                            fit:
                                                                                BoxFit.cover,
                                                                            color: addressController.addressTypeIndex == index
                                                                                ? null
                                                                                : AppColor.gray,
                                                                          ),
                                                                SizedBox(
                                                                  width: 8.w,
                                                                ),
                                                                Text(
                                                                  addressController
                                                                          .addressTypeList[
                                                                      index],
                                                                  style:
                                                                      fontMediumPro,
                                                                )
                                                              ],
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                    ),
                                                  );
                                                }),
                                          ),
                                          addressController.addressTypeIndex ==
                                                  -1
                                              ? const SizedBox()
                                              : addressController
                                                              .addressTypeList[
                                                          addressController
                                                              .addressTypeIndex] !=
                                                      "Others"
                                                  ? const SizedBox()
                                                  : Form(
                                                      key: formKey,
                                                      child: Padding(
                                                        padding:
                                                            EdgeInsets.only(
                                                                top: 5.h),
                                                        child: SizedBox(
                                                          child: TextFormField(
                                                            validator: (value) {
                                                              if (value!
                                                                  .isEmpty) {
                                                                return "Please add level";
                                                              } else {
                                                                return null;
                                                              }
                                                            },
                                                            // controller:
                                                            //     addressController
                                                            //         .labelController,
                                                            onChanged: (value) {
                                                              addressController
                                                                      .selectedAddressType =
                                                                  value;

                                                              print(
                                                                  "on Change Label Value = $value");
                                                              print(
                                                                  "on Change LabelController = ${addressController.selectedAddressType}");
                                                            },
                                                            expands: false,
                                                            decoration:
                                                                InputDecoration(
                                                              fillColor: AppColor
                                                                  .searchBarbg,
                                                              focusedBorder:
                                                                  OutlineInputBorder(
                                                                borderRadius:
                                                                    BorderRadius
                                                                        .all(
                                                                  Radius.circular(
                                                                      12.0.r),
                                                                ),
                                                                borderSide: BorderSide(
                                                                    color: AppColor
                                                                        .searchBarbg,
                                                                    width:
                                                                        2.0.w),
                                                              ),
                                                              enabledBorder:
                                                                  OutlineInputBorder(
                                                                borderRadius: BorderRadius
                                                                    .all(Radius
                                                                        .circular(
                                                                            12.0.r)),
                                                                borderSide: BorderSide(
                                                                    width: 2.w,
                                                                    color: AppColor
                                                                        .dividerColor),
                                                              ),
                                                            ),
                                                          ),
                                                        ),
                                                      ),
                                                    ),
                                        ],
                                      )
                                    : Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Text(
                                            "ADD_LABEL".tr,
                                            style: fontRegularLite,
                                          ),
                                          SizedBox(
                                            height: 9.h,
                                          ),
                                          SizedBox(
                                            child: TextField(
                                              showCursor: true,
                                              readOnly: false,
                                              controller: addressController
                                                  .labelController,
                                              expands: false,
                                              decoration: InputDecoration(
                                                fillColor: AppColor.searchBarbg,
                                                focusedBorder:
                                                    OutlineInputBorder(
                                                  borderRadius:
                                                      BorderRadius.all(
                                                          Radius.circular(
                                                              12.0.r)),
                                                  borderSide: BorderSide(
                                                      color:
                                                          AppColor.searchBarbg,
                                                      width: 2.0.w),
                                                ),
                                                enabledBorder:
                                                    OutlineInputBorder(
                                                  borderRadius:
                                                      BorderRadius.all(
                                                          Radius.circular(
                                                              12.0.r)),
                                                  borderSide: BorderSide(
                                                      width: 2.w,
                                                      color: AppColor
                                                          .dividerColor),
                                                ),
                                              ),
                                            ),
                                          ),
                                          if (addressController
                                                      .selectedAddressType !=
                                                  "Home" &&
                                              addressController
                                                      .selectedAddressType !=
                                                  "Work")
                                            box.read('isLogedIn') != true
                                                ? const SizedBox()
                                                : Form(
                                                    key: formKey,
                                                    child: Padding(
                                                      padding: EdgeInsets.only(
                                                          top: 5.h),
                                                      child: SizedBox(
                                                        child: TextFormField(
                                                          validator: (value) {
                                                            if (value!
                                                                .isEmpty) {
                                                              return "Please add level";
                                                            } else {
                                                              return null;
                                                            }
                                                          },
                                                          controller:
                                                              addressController
                                                                  .labelController,
                                                          expands: false,
                                                          decoration:
                                                              InputDecoration(
                                                            fillColor: AppColor
                                                                .searchBarbg,
                                                            focusedBorder:
                                                                OutlineInputBorder(
                                                              borderRadius: BorderRadius
                                                                  .all(Radius
                                                                      .circular(
                                                                          12.0.r)),
                                                              borderSide: BorderSide(
                                                                  color: AppColor
                                                                      .searchBarbg,
                                                                  width: 2.0.w),
                                                            ),
                                                            enabledBorder:
                                                                OutlineInputBorder(
                                                              borderRadius: BorderRadius
                                                                  .all(Radius
                                                                      .circular(
                                                                          12.0.r)),
                                                              borderSide: BorderSide(
                                                                  width: 2.w,
                                                                  color: AppColor
                                                                      .dividerColor),
                                                            ),
                                                          ),
                                                        ),
                                                      ),
                                                    ),
                                                  ),
                                        ],
                                      ),

                                /*--------[END - ADD LABEL]--------*/
                                SizedBox(height: 16.h),
                                box.read('isLogedIn') != true
                                    ? const SizedBox()
                                    :
                                    // if loggedIn User............
                                    addressController.addressDataList.isEmpty
                                        ? const SizedBox()
                                        : Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Text("SAVED_ADDRESS".tr,
                                                  style: fontMedium),
                                              SizedBox(height: 16.h),
                                              StaggeredGridView.countBuilder(
                                                crossAxisSpacing: 8.w,
                                                mainAxisSpacing: 10.h,
                                                itemCount: addressController
                                                    .addressDataList.length,
                                                crossAxisCount: 2,
                                                physics:
                                                    const NeverScrollableScrollPhysics(),
                                                shrinkWrap: true,
                                                staggeredTileBuilder: (int
                                                        index) =>
                                                    const StaggeredTile.fit(1),
                                                itemBuilder:
                                                    (BuildContext context,
                                                        int index) {
                                                  return InkWell(
                                                    onTap: () {
                                                      addressController
                                                          .addressTypeIndex = -1;
                                                      addressController
                                                          .setInitiallySelectAddressIndex(
                                                              index);

                                                      addressController
                                                              .picketLat =
                                                          double.parse(
                                                              addressController
                                                                  .addressDataList[
                                                                      index]
                                                                  .latitude!);
                                                      addressController
                                                              .picketLong =
                                                          double.parse(
                                                              addressController
                                                                  .addressDataList[
                                                                      index]
                                                                  .longitude!);
                                                    },
                                                    child: Container(
                                                      //  width: 158.w,
                                                      decoration: BoxDecoration(
                                                        borderRadius:
                                                            BorderRadius
                                                                .circular(8.r),
                                                        color: addressController
                                                                    .initialAddressIndex ==
                                                                index
                                                            ? AppColor
                                                                .primaryColor
                                                                .withOpacity(
                                                                    0.08)
                                                            : AppColor.itembg,
                                                        border: addressController
                                                                    .initialAddressIndex ==
                                                                index
                                                            ? Border.all(
                                                                color: AppColor
                                                                    .primaryColor)
                                                            : Border.all(
                                                                color: Colors
                                                                    .white),
                                                      ),
                                                      child: Padding(
                                                        padding:
                                                            EdgeInsets.only(
                                                                bottom: 8.h),
                                                        child: Column(
                                                          children: [
                                                            Row(
                                                              children: [
                                                                SizedBox(
                                                                  // width: 130.w,
                                                                  child: Row(
                                                                    children: [
                                                                      Padding(
                                                                        padding: EdgeInsets.only(
                                                                            top:
                                                                                8.w,
                                                                            left: 8.w,
                                                                            right: 8.h),
                                                                        child: addressController.addressDataList[index].label.toString() ==
                                                                                "Home"
                                                                            ? SvgPicture.asset(
                                                                                Images.homeIcon,
                                                                                fit: BoxFit.cover,
                                                                                height: 15.h,
                                                                                width: 15.w,
                                                                              )
                                                                            : addressController.addressDataList[index].label.toString() == "Work"
                                                                                ? SvgPicture.asset(
                                                                                    Images.work,
                                                                                    fit: BoxFit.cover,
                                                                                  )
                                                                                : SvgPicture.asset(
                                                                                    Images.other,
                                                                                    fit: BoxFit.cover,
                                                                                  ),
                                                                      ),
                                                                      Padding(
                                                                        padding:
                                                                            EdgeInsets.only(top: 8.h),
                                                                        child:
                                                                            Text(
                                                                          addressController
                                                                              .addressDataList[index]
                                                                              .label
                                                                              .toString(),
                                                                          style:
                                                                              TextStyle(
                                                                            fontFamily:
                                                                                'Rubik',
                                                                            fontWeight:
                                                                                FontWeight.w500,
                                                                            fontSize:
                                                                                Dimensions.fontSizeDefault,
                                                                            color:
                                                                                AppColor.blueTextColor,
                                                                          ),
                                                                        ),
                                                                      ),
                                                                    ],
                                                                  ),
                                                                ),
                                                                const Spacer(),
                                                                Padding(
                                                                  padding: EdgeInsets
                                                                      .only(
                                                                          top: 2
                                                                              .w,
                                                                          right:
                                                                              2.w),
                                                                  child:
                                                                      SizedBox(
                                                                    width: 20.w,
                                                                    height:
                                                                        20.h,
                                                                    child: addressController.initialAddressIndex ==
                                                                            index
                                                                        ? SvgPicture
                                                                            .asset(
                                                                            Images.IconVariationSelected,
                                                                            fit:
                                                                                BoxFit.cover,
                                                                          )
                                                                        : SvgPicture
                                                                            .asset(
                                                                            Images.IconVariation,
                                                                            fit:
                                                                                BoxFit.cover,
                                                                          ),
                                                                  ),
                                                                ),
                                                              ],
                                                            ),
                                                            Row(
                                                              children: [
                                                                Expanded(
                                                                  child: Row(
                                                                    children: [
                                                                      Padding(
                                                                        padding: EdgeInsets.only(
                                                                            top:
                                                                                8.h,
                                                                            left: 8.w,
                                                                            right: 8.w),
                                                                        child: SvgPicture
                                                                            .asset(
                                                                          Images
                                                                              .locationIcon,
                                                                          fit: BoxFit
                                                                              .cover,
                                                                        ),
                                                                      ),
                                                                      Flexible(
                                                                        child:
                                                                            Padding(
                                                                          padding:
                                                                              EdgeInsets.only(top: 8.h),
                                                                          child:
                                                                              Text(
                                                                            addressController.addressDataList[index].address.toString(),
                                                                            style:
                                                                                fontRegular,
                                                                            maxLines:
                                                                                2,
                                                                            overflow:
                                                                                TextOverflow.ellipsis,
                                                                          ),
                                                                        ),
                                                                      ),
                                                                    ],
                                                                  ),
                                                                ),
                                                              ],
                                                            ),
                                                            addressController
                                                                        .addressDataList[
                                                                            index]
                                                                        .apartment !=
                                                                    null
                                                                ? Row(
                                                                    children: [
                                                                      Expanded(
                                                                        child:
                                                                            Padding(
                                                                          padding:
                                                                              EdgeInsets.only(left: 28.w),
                                                                          child:
                                                                              Row(
                                                                            children: [
                                                                              Flexible(
                                                                                child: Padding(
                                                                                  padding: EdgeInsets.only(top: 8.h),
                                                                                  child: Text(
                                                                                    addressController.addressDataList[index].apartment.toString(),
                                                                                    style: fontRegular,
                                                                                    maxLines: 1,
                                                                                    overflow: TextOverflow.ellipsis,
                                                                                  ),
                                                                                ),
                                                                              ),
                                                                            ],
                                                                          ),
                                                                        ),
                                                                      ),
                                                                    ],
                                                                  )
                                                                : const SizedBox(),
                                                          ],
                                                        ),
                                                      ),
                                                    ),
                                                  );
                                                },
                                              ),
                                            ],
                                          ),
                                Padding(
                                  padding: EdgeInsets.only(top: 24.h),
                                  child: Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    children: [
                                      ElevatedButton(
                                        onPressed: () async {
                                          print(
                                              "PickLat = ${addressController.picketLat}");
                                          print(
                                              "PickLong = ${addressController.picketLong}");
                                          print(
                                              "initialAdd = ${addressController.initialAddressIndex}");
                                          await homeController
                                              .getBranchByLatLong(
                                                  lat: double.parse(
                                                      addressController
                                                          .picketLat
                                                          .toString()),
                                                  long: double.parse(
                                                      addressController
                                                          .picketLong
                                                          .toString()));
                                        },
                                        style: ElevatedButton.styleFrom(
                                          backgroundColor:
                                              AppColor.primaryColor,
                                          minimumSize: Size(312.w, 52.h),
                                          shape: RoundedRectangleBorder(
                                            borderRadius:
                                                BorderRadius.circular(24.r),
                                          ),
                                        ),
                                        child: Text(
                                          "CONFIRM_LOCATION".tr,
                                          style: fontMedium,
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ]),
                        ),
                      ),
                    ],
                  ),
                ),
              )),
        ),
      ));
}
