import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:foodking/app/modules/address/controllers/address_controller.dart';
import 'package:foodking/app/modules/cart/controllers/cart_controller.dart';
import 'package:foodking/app/modules/home/controllers/home_controller.dart';
import 'package:get/get.dart';
import '../main.dart';
import '../util/constant.dart';
import 'text_widget.dart';

cartResetDialog(
  AddressController addressController,
  HomeController homeController,
) async {
  Get.dialog(AlertDialog(
    actionsAlignment: MainAxisAlignment.spaceEvenly,
    title: Center(
      child: Text("Are you sure?".tr),
    ),
    content: TextWidget(
      maxLines: 2,
      text: "Your cart will reset if you switch to a different branch!".tr,
      fontSize: 13.sp,
    ),
    actions: [
      GestureDetector(
        onTap: () async {
          // Clear the cartReset flag and close dialog
          await box.write('cartReset', false);
          Get.back();
        },
        child: Container(
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(4.r),
            color: AppColor.darkGray.withOpacity(0.6),
          ),
          child: Padding(
            padding: EdgeInsets.symmetric(horizontal: 12.w, vertical: 8.h),
            child: TextWidget(
              text: "No, Cancel".tr,
              color: Colors.white,
              fontSize: 13.sp,
              fontWeight: FontWeight.w500,
            ),
          ),
        ),
      ),
      GestureDetector(
        onTap: () async {
          if (box.read('cartReset')) {
            // Reset the cart and update branch items
            Get.find<CartController>().resetCart();
            // Clear cartReset flag after branch update
            await box.write('cartReset', false);

            await box.write("branchName", box.read('currentBranchName'));
            await box.write("branchId", box.read('currentBranchId'));

            Get.find<HomeController>().onInit();
            addressController.initialAddressIndex = -1;
            addressController.checkoutAddressIndex = -1;
            addressController.addressTypeIndex = -1;

            // Get.back(); // Close the dialog
            // await Future.delayed(const Duration(milliseconds: 100));

            Get.back(); // Close any parent dialogs, if any
            Get.back(); // Close any parent dialogs, if any

            print("Cart reset and Get Back........");
          }
        },
        child: Container(
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(4.r),
            color: AppColor.primaryColor,
          ),
          child: Padding(
            padding: EdgeInsets.symmetric(horizontal: 12.w, vertical: 8.h),
            child: TextWidget(
              text: "Yes, reset it!".tr,
              fontSize: 13.sp,
              color: Colors.white,
              fontWeight: FontWeight.w500,
            ),
          ),
        ),
      ),
    ],
  ));
}












/*
 ------- [Start - Previous Working Code ] -------------------

// import 'package:flutter/material.dart';
// import 'package:flutter_screenutil/flutter_screenutil.dart';
// import 'package:foodking/app/modules/address/controllers/address_controller.dart';
// import 'package:foodking/app/modules/cart/controllers/cart_controller.dart';
// import 'package:foodking/app/modules/home/controllers/home_controller.dart';
// import 'package:get/get.dart';

// import '../main.dart';
// import '../util/constant.dart';
// import 'text_widget.dart';

// cartResetDialog(
//   AddressController addressController,
//   HomeController homeController,
// ) async {
//   Get.dialog(AlertDialog(
//     actionsAlignment: MainAxisAlignment.spaceEvenly,
//     title: Center(
//       child: Text("Are you sure?".tr),
//     ),
//     content: TextWidget(
//       maxLines: 2,
//       text: "Your cart will reset if you switch to a different branch!".tr,
//       fontSize: 13.sp,
//     ),
//     actions: [
//       GestureDetector(
//         onTap: () async {
//           Get.back();
//         },
//         child: Container(
//           decoration: BoxDecoration(
//               borderRadius: BorderRadius.circular(4.r),
//               color: AppColor.darkGray.withOpacity(0.6)),
//           child: Padding(
//               padding: EdgeInsets.symmetric(horizontal: 12.w, vertical: 8.h),
//               child: TextWidget(
//                 text: "No, Cancel".tr,
//                 color: Colors.white,
//                 fontSize: 13.sp,
//                 fontWeight: FontWeight.w500,
//               )),
//         ),
//       ),
//       GestureDetector(
//         onTap: () async {
//           Get.find<CartController>().resetCart();
//           if (box.read('cartReset')) {
//             await homeController.getPopularItemDataList(
//                 branchId: homeController.selectedbranchId.toString());
//             await homeController.getFeaturedItemDataList(
//                 brachId: homeController.selectedbranchId.toString());
//             addressController.initialAddressIndex = -1;
//             addressController.checkoutAddressIndex = -1;
//             addressController.addressTypeIndex = -1;

//             Get.back();
//             Get.back();
//           }
//         },
//         child: Container(
//           decoration: BoxDecoration(
//               borderRadius: BorderRadius.circular(4.r),
//               color: AppColor.primaryColor),
//           child: Padding(
//             padding: EdgeInsets.symmetric(horizontal: 12.w, vertical: 8.h),
//             child: TextWidget(
//               text: "Yes, reset it!".tr,
//               fontSize: 13.sp,
//               color: Colors.white,
//               fontWeight: FontWeight.w500,
//             ),
//           ),
//         ),
//       ),
//     ],
//   ));
// }

 ------- [End - Previous Working Code ] -------------------


*/