// ignore_for_file: no_leading_underscores_for_local_identifiers, use_key_in_widget_constructors, library_private_types_in_public_api, avoid_unnecessary_containers, avoid_renaming_method_parameters, prefer_interpolation_to_compose_strings, unused_import
import 'dart:io';
import 'package:flutter/material.dart';
import 'package:flutter_inappwebview/flutter_inappwebview.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:foodking/app/modules/dashboard/views/dashboard_view.dart';
import 'package:foodking/app/modules/order/views/order_details.dart';
import 'package:foodking/app/modules/splash/controllers/splash_controller.dart';
import 'package:foodking/widget/custom_snackbar.dart';
import 'package:get/get.dart';
import 'package:lottie/lottie.dart';
import 'package:rflutter_alert/rflutter_alert.dart';
import 'package:url_launcher/url_launcher.dart';
import '../../../../util/api-list.dart';
import '../../../../util/constant.dart';
import '../../../../util/style.dart';
import '../../../../widget/custom_toast.dart';
import '../../../../widget/text_widget.dart';
import '../../checkout/widget/order_confirm_dialog_button.dart';
import '../../order/controllers/order_controller.dart';
import 'payment_failed_view.dart';

class PaymentView extends StatefulWidget {
  final int? orderId;
  final String? paymentSlug;
  const PaymentView({
    super.key,
    this.orderId,
    this.paymentSlug,
  });
  @override
  _PaymentViewState createState() => _PaymentViewState();
}

class _PaymentViewState extends State<PaymentView> {
  String? selectedUrl;
  double value = 0.0;
  bool isLoading = true;
  PullToRefreshController pullToRefreshController = PullToRefreshController();
  MyInAppBrowser? browser;

  @override
  void initState() {
    super.initState();
    selectedUrl = APIList.paymentUrl! +
        widget.paymentSlug.toString() +
        "/" +
        widget.orderId.toString() +
        "/pay";

    _initData();
  }

  void _initData() async {
    browser = MyInAppBrowser(widget.orderId, widget.paymentSlug!);
    if (Platform.isAndroid) {
      await AndroidInAppWebViewController.setWebContentsDebuggingEnabled(true);

      bool swAvailable = await AndroidWebViewFeature.isFeatureSupported(
          AndroidWebViewFeature.SERVICE_WORKER_BASIC_USAGE);
      bool swInterceptAvailable =
          await AndroidWebViewFeature.isFeatureSupported(
              AndroidWebViewFeature.SERVICE_WORKER_SHOULD_INTERCEPT_REQUEST);

      if (swAvailable && swInterceptAvailable) {
        AndroidServiceWorkerController serviceWorkerController =
            AndroidServiceWorkerController.instance();
        await serviceWorkerController
            .setServiceWorkerClient(AndroidServiceWorkerClient(
          shouldInterceptRequest: (request) async {
            return null;
          },
        ));
      }
    }

    pullToRefreshController = PullToRefreshController(
      options: PullToRefreshOptions(
        color: AppColor.primaryColor,
      ),
      onRefresh: () async {
        if (Platform.isAndroid) {
          browser?.webViewController.reload();
        } else if (Platform.isIOS) {
          browser?.webViewController.loadUrl(
              urlRequest:
                  URLRequest(url: await browser?.webViewController.getUrl()));
        }
      },
    );
    browser?.pullToRefreshController = pullToRefreshController;

    await browser?.openUrlRequest(
      urlRequest: URLRequest(url: Uri.parse(selectedUrl!)),
      options: InAppBrowserClassOptions(
        crossPlatform:
            InAppBrowserOptions(hideUrlBar: true, hideToolbarTop: true),
        inAppWebViewGroupOptions: InAppWebViewGroupOptions(
          crossPlatform: InAppWebViewOptions(
              javaScriptCanOpenWindowsAutomatically: true,
              javaScriptEnabled: true,
              useShouldOverrideUrlLoading: true,
              allowUniversalAccessFromFileURLs: true,
              useOnLoadResource: true),
        ),
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppColor.primaryColor,
      appBar: AppBar(
        centerTitle: true,
        elevation: 0,
        backgroundColor: Colors.white,
        title: Text(
          'DIGITAL_PAYMENT'.tr,
          style: fontBoldWithColorBlack,
        ),
      ),
      body: Center(
        child: Container(
          child: Stack(
            children: [
              isLoading
                  ? const Center(
                      child: CircularProgressIndicator(
                        valueColor: AlwaysStoppedAnimation<Color>(
                            AppColor.primaryColor),
                      ),
                    )
                  : const SizedBox.shrink(),
            ],
          ),
        ),
      ),
    );
  }
}

class MyInAppBrowser extends InAppBrowser {
  bool _canRedirect = true;
  int? orderID;
  String paymentSlug;

  MyInAppBrowser(this.orderID, this.paymentSlug);

  @override
  Future onBrowserCreated() async {}

  @override
  Future onLoadStart(url) async {
    _pageRedirect(url.toString(), orderID, paymentSlug);
  }

  @override
  Future onLoadStop(url) async {
    pullToRefreshController?.endRefreshing();
    _pageRedirect(url.toString(), orderID, paymentSlug);
  }

  @override
  void onLoadError(url, code, message) {
    pullToRefreshController?.endRefreshing();
  }

  @override
  void onProgressChanged(progress) {
    if (progress == 100) {
      pullToRefreshController?.endRefreshing();
    }
  }

  @override
  void onExit() {
    if (_canRedirect) {
      showDialog(
        context: Get.context!,
        barrierDismissible: false,
        builder: (BuildContext context) {
          return PopScope(
            canPop: false,
            onPopInvokedWithResult: (_, dynamic) async => false,
            child: const AlertDialog(
              contentPadding: EdgeInsets.all(10),
              content: PaymentFailedView(),
            ),
          );
        },
      );
    }
  }

  @override
  Future<NavigationActionPolicy> shouldOverrideUrlLoading(
      navigationAction) async {
    return NavigationActionPolicy.ALLOW;
  }

  @override
  void onLoadResource(response) {
    // print("Started at: " + response.startTime.toString() + "ms ---> duration: " + response.duration.toString() + "ms " + (response.url ?? '').toString());
  }

  @override
  void onConsoleMessage(consoleMessage) {}

  void _pageRedirect(String url, orderID, paymentId) async {
    Future.delayed(const Duration(seconds: 0), () {
      if (_canRedirect) {
        bool _isSuccess =
            url.contains('successful') && url.contains(APIList.baseUrl!);
        bool _isFailed = url.contains('fail') && url.contains(APIList.baseUrl!);
        bool _isCancel =
            url.contains('cancel') && url.contains(APIList.baseUrl!);
        bool _isBack =
            url.contains('checkout') && url.contains(APIList.baseUrl!);
        if (_isSuccess || _isFailed || _isCancel || _isBack) {
          _canRedirect = false;
          close();
        }
        if (_isSuccess) {
          Get.back();

          Get.offAll(() => const DashboardView());

          Get.dialog(
              barrierDismissible: false,
              Dialog(
                insetPadding: EdgeInsets.all(10.r),
                backgroundColor: Colors.transparent,
                child: Stack(
                  children: [
                    Wrap(
                      children: [
                        Container(
                          width: 328.w,
                          decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(16.r)),
                          child: Padding(
                            padding: EdgeInsets.all(16.r),
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                SizedBox(
                                  height: 16.h,
                                ),
                                TextWidget(
                                  text: 'Thank you for your order!'.tr,
                                  color: Colors.black,
                                  fontSize: 16.sp,
                                  fontWeight: FontWeight.w500,
                                ),
                                SizedBox(
                                  height: 20.h,
                                ),
                                Lottie.asset(Images.animationConfirmed,
                                    width: 120.w, height: 120.h),
                                SizedBox(
                                  height: 20.h,
                                ),
                                TextWidget(
                                  text: 'Your order is confirmed.'.tr,
                                  color: Colors.black,
                                  fontSize: 16.sp,
                                  fontWeight: FontWeight.w500,
                                ),
                                SizedBox(
                                  height: 16.h,
                                ),
                                DialogButton(
                                  color: AppColor.primaryColor,
                                  onPressed: () {
                                    Get.back();
                                    Get.to(() =>
                                        OrderDetailsView(orderId: orderID));
                                  },
                                  radius: BorderRadius.circular(24.0.r),
                                  child: FittedBox(
                                    child: Text(
                                      "GO_TO_ORDER_DETAILS".tr,
                                      style: fontMediumProWhite,
                                      maxLines: 1,
                                      overflow: TextOverflow.ellipsis,
                                    ),
                                  ),
                                )
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                    Positioned(
                      top: 16.h,
                      right: 16.w,
                      child: InkWell(
                        onTap: () {
                          Get.back();
                        },
                        child: SvgPicture.asset(
                          Images.IconClose,
                          height: 24.h,
                          width: 24.w,
                        ),
                      ),
                    )
                  ],
                ),
              ));

          if (paymentSlug == "cashondelivery" || paymentSlug == "credit") {
          } else {
            customSnackbar("DIGITAL_PAYMENT".tr,
                "YOUR_PAYMENT_HAS_BEEN_CONFIRMED".tr, AppColor.success);
          }
        } else if (_isFailed || _isCancel || _isBack) {
          Get.back();
          customSnackbar(
              "DIGITAL_PAYMENT".tr, "PAYMENT_FAILED".tr, AppColor.error);
        }
      }
    });
  }
}
