import 'package:flutter/material.dart';
import 'package:foodking/app/modules/address/controllers/address_controller.dart';
import 'package:foodking/app/modules/cart/controllers/cart_controller.dart';
import 'package:foodking/main.dart';
import 'package:foodking/util/constant.dart';
import 'package:foodking/widget/custom_snackbar.dart';
import 'package:get/get.dart';
import 'package:get_storage/get_storage.dart';
import '../../../../widget/cart_reset_dialog.dart';
import '../../../data/api/server.dart';
import '../../../data/model/response/branch_model.dart';
import '../../../data/model/response/category_model.dart';
import '../../../data/model/response/item_model.dart';
import '../../../data/model/response/order_mode.dart';
import '../../../data/repository/branch_repo.dart';
import '../../../data/repository/category_repo.dart';
import '../../../data/repository/featured_item_repo.dart';
import '../../../data/repository/item_repo.dart';
import '../../../data/repository/my_order_repo.dart';
import '../../../data/repository/popular_item_repo.dart';

class HomeController extends GetxController {
  final addressController = Get.put(AddressController());
  // final homeController = Get.find<HomeController>();
  static Server server = Server();
  List<OrdersData> activeOrderData = <OrdersData>[];
  List<CategoryData> categoryDataList = <CategoryData>[];
  List<ItemData> itemDataList = <ItemData>[];
  List<ItemData> popularItemDataList = <ItemData>[];
  List<ItemData> featuredItemDataList = <ItemData>[];
  BranchData brachData = BranchData();

  String? selectedBranch;
  int? selectedbranchId;

  bool loader = false;
  bool menuLoader = false;
  bool featuredLoader = false;
  bool offerLoader = false;
  bool popularLoader = false;
  bool activeOrderLoader = false;
  int selectedBranchIndex = 0;
  final selectedBranchLocal = ''.obs;
  TextEditingController branch = TextEditingController();
  TextEditingController zipCode = TextEditingController();
  final useZipCode = true.obs;
  bool showCloseIcon = true;
  bool branchFoundInZone = false;

  //khaled code
  final currentBranchName = ''.obs;
  final currentBranchId = 0.obs;
  final isZoneFound = false.obs;

  @override
  void onInit() {
    final box = GetStorage();

    if (box.read('branchId') != null) {
      setBranchId(box.read('branchId'));
    }

    getCategoryList();
    getPopularItemDataList(branchId: box.read('branchId').toString());
    getFeaturedItemDataList(brachId: box.read('branchId').toString());
    getItemDataList();
    if (box.read('isLogedIn') == true && box.read('isLogedIn') != null) {
      getActiveOrderList();
    }

    super.onInit();
  }

  dialogClose(bool isShowCloseIcon) {
    showCloseIcon = isShowCloseIcon;
    update();
  }

  setBranchId(int branchId) {
    selectedbranchId = branchId;

    print("SeTBranch SelectedID = $branchId");
    update();
  }

  getCategoryList() async {
    menuLoader = true;
    update();
    var categoryData = await CategoryRepo.getCategory();
    if (categoryData != null) {
      categoryDataList = categoryData.data!;
      menuLoader = false;
      update();
    } else {
      menuLoader = false;
      update();
    }
  }

  // Currently Actively Working code

  // getBranchByLatLong({required double lat, required double long}) async {
  //   final result =
  //       await BranchRepo.getBranchByLatLong(latitude: lat, longitude: long);

  //   result.fold((error) {
  //     customSnackbar("ERROR".tr, error, AppColor.primaryColor);
  //   }, (data) async {
  //     brachData = data;
  //     setBranchInfo();
  //     onInit();

  //     if (Get.find<CartController>().cart.isNotEmpty) {
  //       // check user logged in
  //       if (box.read('isLogedIn')) {
  //         // logged in YES + SavedAddress

  //         if (addressController.initialAddressIndex != -1) {
  //           print("cart Not empty + loggedIn + SavedAddress");
  //           print("savedAddIndex = ${addressController.initialAddressIndex}");

  //           // braches are different...........
  //           print("CartRest in savedAddress = ${box.read('cartReset')}");
  //           if (box.read('cartReset')) {
  //             print("Branch Different");
  //             await cartResetDialog(addressController, HomeController());
  //           } else {
  //             print("Same Branch");
  //             Future.delayed(Duration(milliseconds: 100));
  //             Get.back();
  //           }
  //         } else {
  //           // LoggedIn + addNewAddress

  //           print("Cart Not empty + loggedIn + Not Selected AddLabelButton ");
  //           if (addressController.addressTypeIndex == -1) {
  //             // AddressButton Not selected
  //             customSnackbar(
  //                 "ERROR".tr, "LABEL_IS_REQUIRED".tr, AppColor.redColor);
  //           } else {
  //             // AddressButton is selected

  //             print("Cart Not empty + loggedIn + Selected AddLabelButton ");

  //             if (addressController
  //                     .addressTypeList[addressController.addressTypeIndex] !=
  //                 "Others") {
  //               // AddressButton Type is HOME,Work...........

  //               print("Cart Not empty + loggedIn + Label - Home,Work ");

  //               if (box.read('isZoneFound')) {
  //                 await addressController.addAddress();

  //                 print("LABEL STATUS HERE = ${box.read("isLabelTaken")}");
  //                 if (box.read("isLabelTaken") == false) {
  //                   print("In zone + Label is not taken");
  //                   if (box.read('cartReset')) {
  //                     print("In Zone + Label is not same + Branch Different");
  //                     await cartResetDialog(
  //                         addressController, HomeController());
  //                   } else {
  //                     try {
  //                       await addressController.addAddress();
  //                       print("Attempting to close dialog...");
  //                       print("Dialog will be closed from postAdddressMethod");
  //                       //  Get.back(); // This should close the dialog asdf
  //                     } catch (e) {
  //                       print("Error when trying to close dialog: $e");
  //                     }
  //                   }
  //                 } else {
  //                   print("In Zone + Label Is Taken");
  //                 }
  //               }
  //             } else {
  //               // LabelBUtton is others.............
  //               print("Cart Not empty + loggedIn + Label - Others");
  //               if (addressController.selectedAddressType.isEmpty) {
  //                 // Label Text is Empty.......
  //                 customSnackbar(
  //                     "ERROR".tr, "LABEL_IS_REQUIRED".tr, AppColor.redColor);
  //               } else {
  //                 print("Branch Different Starts From here");

  //                 print('isZoneFoune = ${box.read('isZoneFound')}');
  //                 if (box.read('isZoneFound')) {
  //                   await addressController.addAddress();

  //                   Future.delayed(const Duration(seconds: 2));

  //                   print("Label Statusssssssss = ${box.read("isLabelTaken")}");

  //                   // braches are different...........
  //                   if (box.read("isLabelTaken") == false) {
  //                     print("In zone + Label is not taken");
  //                     if (box.read('cartReset')) {
  //                       print("In Zone + Label is not same + Branch Different");
  //                       await cartResetDialog(
  //                           addressController, HomeController());
  //                     } else {
  //                       print("In Zone + Label is Not Taken + Branch are same");
  //                       await addressController.addAddress();
  //                       Get.back();
  //                     }
  //                   } else {
  //                     print("In Zone + Label Is Taken");
  //                   }
  //                 }
  //               }
  //             }
  //           }
  //         }
  //       } else {
  //         // Not Logged In...............

  //         print("Not loggggeddd in");

  //         if (addressController.labelController.text.isEmpty) {
  //           customSnackbar(
  //               "ERROR".tr, "LABEL_IS_REQUIRED".tr, AppColor.redColor);
  //         } else {
  //           //Not login and label is not empty.......
  //           print("Branch Status = ${box.read('cartReset')}");
  //           if (box.read('isZoneFound')) {
  //             // braches are different...........
  //             if (await box.read('cartReset')) {
  //               print("Cart NOt empty + No Login + inZone + Different");
  //               print("Address save locally..");
  //               print("Cart will be reset");

  //               await cartResetDialog(addressController, HomeController());

  //               await box.write("initialAddress", {
  //                 "label": addressController.labelController.text,
  //                 "lat": addressController.picketLat,
  //                 "long": addressController.picketLong,
  //                 "address": addressController.pickAddress,
  //                 "apartment": addressController.apartmentController.text,
  //               });

  //               print("local Address = ${box.read('initialAddress')}");
  //               // await cartResetDialog(addressController, HomeController());
  //             } else {
  //               print("Cart NOt empty + No Login + inZone + SameBranch");
  //               box.write("initialAddress", {
  //                 "label": addressController.labelController.text,
  //                 "lat": addressController.picketLat,
  //                 "long": addressController.picketLong,
  //                 "address": addressController.pickAddress,
  //                 "apartment": addressController.apartmentController.text,
  //               });

  //               print("local Address = ${box.read('initialAddress')}");

  //               Get.back();
  //             }
  //           }
  //         }
  //       }
  //     }
  //     // If Cart Is Empty

  //     else {
  //       // Cart Empty + user Not loggedIn.......

  //       if (box.read('isLogedIn') != true) {
  //         // not logged in + label is empty
  //         print("cart empty + Not loggedin + label empty");
  //         if (addressController.labelController.text.isEmpty) {
  //           customSnackbar(
  //               "ERROR".tr, "LABEL_IS_REQUIRED".tr, AppColor.redColor);
  //         }

  //         // not logged in + label is Not empty
  //         // Delivery Address Saved locally..........
  //         else {
  //           print("cart empty + Not loggedin + label is Not empty");

  //           // if branch is in zone

  //           if (box.read('isZoneFound')) {
  //             // DElivery Address Saved locally..............
  //             box.write("initialAddress", {
  //               "label": addressController.labelController.text,
  //               "lat": addressController.picketLat,
  //               "long": addressController.picketLong,
  //               "address": addressController.pickAddress,
  //               "apartment": addressController.apartmentController.text,
  //             });

  //             print("Local Deli Add = ${box.read('initialAddress')}");
  //             Get.back();
  //           } else {
  //             print("zone not found");
  //           }
  //         }
  //       }

  //       // Cart Empty + user Loggedin.......
  //       else {
  //         // During logged save delivery Address..........

  //         print("Cart empty + user loggedin");

  //         // cart empty + loggedIn + Not Select savedAddress
  //         if (addressController.initialAddressIndex == -1 &&
  //             addressController.addressTypeIndex == -1 &&
  //             addressController.selectedAddressType.isEmpty) {
  //           print("Called this one");
  //           customSnackbar(
  //               "ERROR".tr, "LABEL_IS_REQUIRED".tr, AppColor.redColor);
  //         }

  //         if (addressController.initialAddressIndex == -1 &&
  //             addressController.addressTypeIndex != -1) {
  //           // cart empty + loggedIn + Select LabelBUtton
  //           print("cart empty + loggedIn + Select LabelBUtton");
  //           if (addressController.selectedAddressType.isEmpty) {
  //             print("Label.text is empty");
  //             customSnackbar(
  //                 "ERROR".tr, "LABEL_IS_REQUIRED".tr, AppColor.redColor);
  //           }
  //           // cart empty + loggedIn + Select LabelBUtton - Label is not emtpy
  //           else {
  //             print("ZoneFounddddd = ${box.read('isZoneFound')}");

  //             if (box.read('isZoneFound')) {
  //               print("Type Label = ${addressController.selectedAddressType}");
  //               await addressController.addAddress();
  //               if (box.read('isLabelTaken') == false) {
  //                 print("Go Back");
  //               }
  //             }
  //           }

  //           // cart empty + loggedIn + Selected savedAddress
  //         } else if (addressController.initialAddressIndex != -1 &&
  //             addressController.selectedAddressType.isEmpty) {
  //           print("cart empty + userLoging + savedAddress");

  //           if (box.read('isZoneFound')) {
  //             print("Branch in zone, Get Back");
  //             Get.back();
  //           }
  //         }
  //       }
  //     }
  //   });
  // }

  Future<void> getBranchByLatLong(
      {required double lat, required double long}) async {
    final result =
        await BranchRepo.getBranchByLatLong(latitude: lat, longitude: long);

    result.fold(
      (error) {
        customSnackbar("ERROR".tr, error, AppColor.primaryColor);
      },
      (data) async {
        brachData = data;

        await box.write('currentBranchName', brachData.name.toString());
        await box.write('currentBranchId', brachData.id);
        await box.write("branchAddress", brachData.address);
        await box.write('branchLat', brachData.latitude);
        await box.write('branchLong', brachData.longitude);

        setBranchId(await box.read('branchId'));

        // Check if the cart is not empty
        if (Get.find<CartController>().cart.isNotEmpty) {
          await _handleNonEmptyCart();
        }
        // If the cart is empty
        else {
          await _handleEmptyCart();
        }
      },
    );
  }

  Future<void> _handleNonEmptyCart() async {
    if (box.read('isLogedIn')) {
      await _handleLoggedInUserWithCart();
    } else {
      await _handleGuestUserWithCart();
    }
  }

  Future<void> _handleLoggedInUserWithCart() async {
    // If there's a saved address
    if (addressController.initialAddressIndex != -1) {
      await _handleSavedAddress();
    }
    // If no saved address, but user is logged in
    else {
      await _handleNewAddress();
    }
  }

  Future<void> _handleSavedAddress() async {
    print("Cart Not empty + loggedIn + SavedAddress");
    print("savedAddIndex = ${addressController.initialAddressIndex}");

    // Check if cart should reset
    if (box.read('cartReset')) {
      print("Branch Different");
      await cartResetDialog(addressController, HomeController());
    } else {
      print("Same Branch");
      Future.delayed(const Duration(milliseconds: 100));
      Get.back();
    }
  }

  Future<void> _handleNewAddress() async {
    print("Cart Not empty + loggedIn + Not Selected AddLabelButton ");

    if (addressController.addressTypeIndex == -1) {
      customSnackbar("ERROR".tr, "LABEL_IS_REQUIRED".tr, AppColor.redColor);
    } else {
      print("Cart Not empty + loggedIn + Selected AddLabelButton ");
      await _handleAddressTypeSelection();
    }
  }

  Future<void> _handleAddressTypeSelection() async {
    if (addressController.addressTypeList[addressController.addressTypeIndex] !=
        "Others") {
      await _handleStandardAddressType();
    } else {
      await _handleOtherAddressType();
    }
  }

  Future<void> _handleStandardAddressType() async {
    print("Cart Not empty + loggedIn + Label - Home, Work ");

    if (box.read('isZoneFound')) {
      await addressController.addAddress();

      if (!box.read("isLabelTaken")) {
        print("In zone + Label is not taken");

        if (box.read('cartReset')) {
          print("In Zone + Label is not same + Branch Different");
          await cartResetDialog(addressController, HomeController());
        } else {
          await addressController.addAddress();
          Get.back();
        }
      } else {
        print("In Zone + Label Is Taken");
      }
    }
  }

  Future<void> _handleOtherAddressType() async {
    print("Cart Not empty + loggedIn + Label - Others");

    if (addressController.selectedAddressType.isEmpty) {
      customSnackbar("ERROR".tr, "LABEL_IS_REQUIRED".tr, AppColor.redColor);
    } else {
      print("Branch Different Starts From here");
      print('isZoneFoune = ${box.read('isZoneFound')}');

      if (box.read('isZoneFound')) {
        await addressController.addAddress();
        Future.delayed(const Duration(seconds: 2));
        print("Label Statusssssssss = ${box.read("isLabelTaken")}");

        if (!box.read("isLabelTaken")) {
          print("In zone + Label is not taken");

          if (box.read('cartReset')) {
            print("In Zone + Label is not same + Branch Different");
            await cartResetDialog(addressController, HomeController());
          } else {
            print("In Zone + Label is Not Taken + Branch are same");
            await addressController.addAddress();
            Get.back();
          }
        } else {
          print("In Zone + Label Is Taken");
        }
      }
    }
  }

  Future<void> _handleGuestUserWithCart() async {
    print("Not logged in");

    if (addressController.labelController.text.isEmpty) {
      customSnackbar("ERROR".tr, "LABEL_IS_REQUIRED".tr, AppColor.redColor);
    } else {
      print("Branch Status = ${box.read('cartReset')}");

      if (box.read('isZoneFound')) {
        if (await box.read('cartReset')) {
          print("Cart Not empty + No Login + inZone + Different");
          await cartResetDialog(addressController, HomeController());
          await _saveAddressLocally();
        } else {
          print("Cart Not empty + No Login + inZone + SameBranch");
          await _saveAddressLocally();
          Get.back();
        }
      }
    }
  }

  Future<void> _saveAddressLocally() async {
    await box.write("initialAddress", {
      "label": addressController.labelController.text,
      "lat": addressController.picketLat,
      "long": addressController.picketLong,
      "address": addressController.pickAddress,
      "apartment": addressController.apartmentController.text,
    });
    print("local Address = ${box.read('initialAddress')}");
  }

  Future<void> _handleEmptyCart() async {
    if (!box.read('isLogedIn')) {
      await _handleEmptyCartForGuest();
    } else {
      await _handleEmptyCartForLoggedInUser();
    }
  }

  Future<void> _handleEmptyCartForGuest() async {
    print("cart empty + Not loggedin + label empty");

    if (addressController.labelController.text.isEmpty) {
      customSnackbar("ERROR".tr, "LABEL_IS_REQUIRED".tr, AppColor.redColor);
    } else {
      print("cart empty + Not loggedin + label is Not empty");
      if (box.read('isZoneFound')) {
        await box.write("branchName", box.read('currentBranchName'));
        await box.write("branchId", box.read('currentBranchId'));

        Get.find<HomeController>().onInit();
        await _saveAddressLocally();
        Get.back();
      } else {
        print("zone not found");
      }
    }
  }

  Future<void> _handleEmptyCartForLoggedInUser() async {
    print("Cart empty + user loggedin");

    if (addressController.initialAddressIndex == -1 &&
        addressController.addressTypeIndex == -1 &&
        addressController.selectedAddressType.isEmpty) {
      customSnackbar("ERROR".tr, "LABEL_IS_REQUIRED".tr, AppColor.redColor);
    } else if (addressController.initialAddressIndex == -1 &&
        addressController.addressTypeIndex != -1) {
      await _handleLabelButtonSelection();
    } else if (addressController.initialAddressIndex != -1 &&
        addressController.addressTypeIndex == -1) {
      await _handleSelectedSavedAddress();
    }
  }

  Future<void> _handleLabelButtonSelection() async {
    print("cart empty + loggedIn + Select LabelBUtton");

    if (addressController.selectedAddressType.isEmpty) {
      print("Label.text is empty");
      customSnackbar("ERROR".tr, "LABEL_IS_REQUIRED".tr, AppColor.redColor);
    } else {
      print("ZoneFounddddd = ${box.read('isZoneFound')}");

      if (box.read('isZoneFound')) {
        print("Type Label = ${addressController.selectedAddressType}");
        await addressController.addAddress();

        await box.write("branchName", box.read('currentBranchName'));
        await box.write("branchId", box.read('currentBranchId'));

        box.remove('currentBranchName');
        box.remove('currentBranchId');

        Get.find<HomeController>().onInit();

        if (!box.read('isLabelTaken')) {
          print("Go Back");
        }
      }
    }
  }

  Future<void> _handleSelectedSavedAddress() async {
    print("cart empty + user loggedin + savedAddress");

    if (box.read('isZoneFound')) {
      await box.write("branchName", box.read('currentBranchName'));
      await box.write("branchId", box.read('currentBranchId'));

      box.remove('currentBranchName');
      box.remove('currentBranchId');

      Get.find<HomeController>().onInit();
      print("Branch in zone, Get Back");
      Get.back();
    }
  }

  //  checkoutAddressZoneChecker(
  //     {required double lat, required double long}) async {
  //   final result = await BranchRepo.checkoutAddressZoneChecker(
  //       latitude: lat, longitude: long);

  //   result.fold(
  //       (error) => customSnackbar("ERROR".tr, error, AppColor.primaryColor),
  //       (data) {

  //       });
  // }

  // setBranchInfo() {
  //   selectedBranch = null;
  //   selectedbranchId = null;
  //   selectedBranch = brachData.name;
  //   selectedbranchId = brachData.id;

  //   print("BranchData Name = $selectedBranch");
  //   print("BranchData Id = $selectedbranchId");

  //   update();
  // }

  getItemDataList() async {
    var itemData = await ItemRepo.getItem();
    if (itemData != null) {
      itemDataList = itemData.data!;
      update();
    } else {
      update();
    }
  }

  getPopularItemDataList({required String branchId}) async {
    popularLoader = true;
    update();
    var popularItemData =
        await PopularItemRepo.getPopularItem(branchId: branchId);
    if (popularItemData != null) {
      popularItemDataList = popularItemData.data ?? [];
      popularLoader = false;
      update();
    } else {
      update();
    }
  }

  getFeaturedItemDataList({required String brachId}) async {
    featuredLoader = true;
    update();
    var featuredItemData =
        await FeaturedItemRepo.getFeaturedItem(branchId: brachId);
    featuredLoader = false;
    update();
    featuredItemData.fold((error) {
      featuredLoader = false;
      update();
    }, (data) {
      featuredItemDataList = data.data ?? [];
      update();
    });
  }

  getActiveOrderList() async {
    var activeOrder = await MyOrderRepo.getActiveOrder();
    if (activeOrder != null) {
      activeOrderData = activeOrder.data!;
      update();
    } else {}
  }
}
