// ignore_for_file: prefer_const_constructors_in_immutables, sort_child_properties_last, prefer_interpolation_to_compose_strings, unnecessary_null_comparison, no_leading_underscores_for_local_identifiers, use_build_context_synchronously, deprecated_member_use
import 'dart:collection';
import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:foodking/app/modules/profile/controllers/profile_controller.dart';
import 'package:foodking/widget/text_widget.dart';
import 'package:geolocator/geolocator.dart';
import 'package:get/get.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';
import 'package:shimmer/shimmer.dart';
import 'package:toggle_switch/toggle_switch.dart';
import '../../../../main.dart';
import '../../../../util/constant.dart';
import '../../../../util/style.dart';
import '../../../../widget/custom_snackbar.dart';
import '../../../../widget/custom_toast.dart';
import '../../../../widget/divider_widget.dart';
import '../../../../widget/loader.dart';
import '../../../data/model/body/place_order_body.dart';
import '../../address/widget/addAddress/add_pick_location_view.dart';
import '../../address/widget/editAddress/edit_pick_location_view.dart';
import '../../cart/controllers/cart_controller.dart';
import '../../cart/widgets/cart_instruction_widget.dart';
import '../../cart/widgets/cart_variation_widget.dart';
import '../../home/controllers/home_controller.dart';
import '../../address/controllers/address_controller.dart';
import '../../profile/widget/location_permission_dialouge.dart';
import '../../splash/controllers/splash_controller.dart';
import '../controllers/checkout_controller.dart';
import '../controllers/coupon_controller.dart';
import '../controllers/order_controller.dart';
import '../widget/apply_offer_card_widget.dart';
import '../widget/time_slot_widget.dart';
import 'package:flutter_staggered_grid_view/flutter_staggered_grid_view.dart';

class CheckoutView extends StatefulWidget {
  final int? orderId;
  CheckoutView({Key? key, this.orderId}) : super(key: key);

  @override
  State<CheckoutView> createState() => _CheckoutViewState();
}

class _CheckoutViewState extends State<CheckoutView> {
  GoogleMapController? _mapController;
  CameraPosition? _initialCameraPosition;
  bool mapLoading = true;

  SplashController connect = Get.put(SplashController());
  CartController cartController = Get.put(CartController());
  ProfileController profileController = Get.put(ProfileController());
  AddressController addressController = Get.put(AddressController());
  HomeController homeController = Get.put(HomeController());

  Set<Marker> _markers = HashSet<Marker>();
  bool maploading = true;
  double branchLat = 0.0;
  double branchLong = 0.0;
  double addressLat = 0.0;
  double addressLon = 0.0;
  final checkoutController = Get.put(CheckoutController());

  bool isActive = true;
  int isAdvanceOrder = 10;

  @override
  void initState() {
    super.initState();

    CheckoutController checkoutController = Get.put(CheckoutController());
    SplashController splashController = Get.put(SplashController());

    addressController.getAddressList();
    checkoutController.getPaymentGateways();
    checkoutController.getPoints();
    checkoutController.getTips();
    checkoutController.getTodayTime(
        branchID: homeController.selectedbranchId.toString());
    checkoutController.getTomorrowTime(
        branchID: homeController.selectedbranchId.toString());
    checkoutController.isPointApply.value = false;
    connect.getConfiguration();

    checkoutController.selectPaymentMethod.value = -1;
    checkoutController.selectedTipIndex.value = -1;

    // Check if lat/long are available, and set initial position
    if (addressController.picketLat != null &&
        addressController.picketLong != null) {
      _initialCameraPosition = CameraPosition(
        target: LatLng(double.parse(box.read("branchLat").toString()),
            double.parse(box.read("branchLong").toString())),
        zoom: 16,
      );
    }

    if (addressController.addressDataList.isNotEmpty) {
      addressLat = double.parse(addressController
          .addressDataList[addressController.selectedBranchIndex].latitude
          .toString());
      addressLon = double.parse(addressController
          .addressDataList[addressController.selectedBranchIndex].longitude
          .toString());
    }

    if (checkoutController.todayDataList.isNotEmpty) {
      isAdvanceOrder = 10;
    }

    if (splashController.configData.orderSetupDelivery == 10 &&
        splashController.configData.orderSetupTakeaway == 5) {
      cartController.orderTypeIndex = 1;
    }
    if (splashController.configData.orderSetupDelivery == 10 &&
        splashController.configData.orderSetupTakeaway == 10) {
      cartController.orderTypeIndex = 10;
    }

    // addressController.selectedAddress = null;
    cartController.deliveryCharge = 0.0;
    checkoutController.selectDateSlot = 0;
    checkoutController.selectTimeSlot = 0;

    WidgetsBinding.instance.addPostFrameCallback((_) {
      Map<String, dynamic>? initialLocalAddress = box.read('initialAddress');

      if (initialLocalAddress != null &&
          addressController.addressDataList.isNotEmpty &&
          addressController.initialAddressIndex == -1 &&
          cartController.orderTypeIndex != 1) {
        for (int index = 0;
            index < addressController.addressDataList.length;
            index++) {
          if (initialLocalAddress["id"].toString() ==
              addressController.addressDataList[index].id.toString()) {
            setInitialLocalCheckoutAddress();
            break;
          } else {}
        }
      } else {
        setInitialSelectedCheckoutAddress();
      }
      cartController.calculateTotal();
    });
  }

  /// For local initial Address.....................................

  setInitialLocalCheckoutAddress() async {
    var distance = 0.0;
    addressController.setCheckoutAddressIndex(0);
    int index = addressController.checkoutAddressIndex;

    // new code for localAddress -> as checkoutAddress

    setState(() {
      addressLat = double.parse(
          addressController.addressDataList[index].latitude.toString());

      addressLon = double.parse(
          addressController.addressDataList[index].longitude.toString());

      branchLat = double.parse(box.read('branchLat').toString());
      branchLong = double.parse(box.read('branchLong').toString());

      distance = Get.find<CartController>()
          .calculateDistance(addressLat, addressLon, branchLat, branchLong);
    });

    print("distance = $distance");

    await checkoutController
        .checkDistance(
      branchId: homeController.selectedbranchId.toString(),
      distance: distance.toString(),
      latitude: addressController.addressDataList[index].latitude.toString(),
      longitude: addressController.addressDataList[index].longitude.toString(),
    )
        .then((_) {
      if (checkoutController
              .distanceModel.value.data?.convertMinimumOrderAmount ==
          null) {
        // For set checkout address
        if (checkoutController.isStatus) {
          addressController.setAddress(index);
          cartController.distanceWiseDeliveryCharge();
          cartController.calculateTotal();

          print("CartValue = ${cartController.totalCartValue}");
        } else {
          addressController.setAddress(-1);

          cartController.calculateTotal();
          print("CartValue = ${cartController.totalCartValue}");
        }

        checkoutController.getPaymentGateways();
      } else {
        if (checkoutController
                .distanceModel.value.data!.convertMinimumOrderAmount! >
            cartController.totalCartValue) {
          addressController.checkoutAddressIndex = -1;
          setState(() {});

          customTast(
              "FOR_THIS_AREA_MINIMUM_ORDER_IS".tr +
                  " ${checkoutController.distanceModel.value.data!.currencyMinimumOrderAmount}"
                      .tr,
              AppColor.error);

          cartController.calculateTotal();
          checkoutController.getPaymentGateways();
        } else {
          setState(() {
            addressController.setAddress(index);
            Get.find<CartController>().calculateDistanceWithMinimumOrder(
                checkoutController
                        .distanceModel.value.data!.convertMinimumOrderAmount
                        ?.toDouble() ??
                    0.0);
            cartController.calculateTotal();
            checkoutController.getPaymentGateways();
          });
        }
      }
    });
  }

  // For Selected initial Checkout Address.......................
  setInitialSelectedCheckoutAddress() async {
    var distance = 0.0;

    addressController
        .setCheckoutAddressIndex(addressController.initialAddressIndex!);

    // For selected Initial Address -> as CheckoutAddress
    int index = addressController.checkoutAddressIndex;

    // new code for localAddress -> as checkoutAddress

    setState(() {
      addressLat = double.parse(
          addressController.addressDataList[index].latitude.toString());

      addressLon = double.parse(
          addressController.addressDataList[index].longitude.toString());

      branchLat = double.parse(box.read('branchLat').toString());
      branchLong = double.parse(box.read('branchLong').toString());

      distance = Get.find<CartController>()
          .calculateDistance(addressLat, addressLon, branchLat, branchLong);
    });

    print("distance = $distance");

    await checkoutController
        .checkDistance(
      branchId: homeController.selectedbranchId.toString(),
      distance: distance.toString(),
      latitude: addressController.addressDataList[index].latitude.toString(),
      longitude: addressController.addressDataList[index].longitude.toString(),
    )
        .then((_) {
      if (checkoutController
              .distanceModel.value.data?.convertMinimumOrderAmount ==
          null) {
        // For set checkout address
        if (checkoutController.isStatus) {
          addressController.setAddress(index);
          cartController.distanceWiseDeliveryCharge();
          cartController.calculateTotal();

          print("CartValue = ${cartController.totalCartValue}");
        } else {
          addressController.setAddress(-1);

          cartController.calculateTotal();
          print("CartValue = ${cartController.totalCartValue}");
        }

        // cartController
        //     .distanceWiseDeliveryCharge();
        // cartController
        //     .calculateTotal();
        checkoutController.getPaymentGateways();
      } else {
        if (checkoutController
                .distanceModel.value.data!.convertMinimumOrderAmount! >
            cartController.totalCartValue) {
          addressController.checkoutAddressIndex = -1;
          setState(() {});

          customTast(
              "FOR_THIS_AREA_MINIMUM_ORDER_IS".tr +
                  " ${checkoutController.distanceModel.value.data!.currencyMinimumOrderAmount}"
                      .tr,
              AppColor.error);

          cartController.calculateTotal();
          checkoutController.getPaymentGateways();
        } else {
          setState(() {
            addressController.setAddress(index);
            Get.find<CartController>().calculateDistanceWithMinimumOrder(
                checkoutController
                        .distanceModel.value.data!.convertMinimumOrderAmount
                        ?.toDouble() ??
                    0.0);
            cartController.calculateTotal();
            checkoutController.getPaymentGateways();
          });
        }
      }
    });
  }

  @override
  void dispose() {
    cartController.deliveryCharge = 0.0;
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    CartController cartController = Get.put(CartController());
    AddressController addressController = Get.put(AddressController());
    HomeController homeController = Get.put(HomeController());
    SplashController splashController = Get.put(SplashController());

    return GetBuilder<PlaceOrderController>(
      builder: (placeOrderController) => Stack(
        children: [
          Scaffold(
              resizeToAvoidBottomInset: false,
              backgroundColor: Colors.white,
              appBar: AppBar(
                titleSpacing: -5,
                title: Text(
                  'CHECKOUT'.tr,
                  style: fontBoldWithColorBlack,
                ),
                centerTitle: false,
                elevation: 0,
                backgroundColor: Colors.white,
                leading: IconButton(
                  icon: SvgPicture.asset(Images.back),
                  onPressed: () {
                    Get.back();
                  },
                ),
              ),
              body: Stack(
                children: [
                  SizedBox(
                    height: Get.height,
                    child: RefreshIndicator(
                      color: AppColor.primaryColor,
                      onRefresh: () async {
                        await checkoutController.getPoints();
                        print(
                            "Point Data -  ${checkoutController.pointsModel.value.data?.isPointApplicable}");
                      },
                      child: SingleChildScrollView(
                        physics: const BouncingScrollPhysics(),
                        child: Column(
                          children: [
                            //branch map
                            homeController.brachData != null
                                ? Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Padding(
                                        padding: EdgeInsets.only(
                                            left: 16.w,
                                            right: 16.w,
                                            top: 16.h,
                                            bottom: 16.h),
                                        child: SizedBox(
                                          height: 140.h,
                                          child: ClipRRect(
                                            borderRadius:
                                                BorderRadius.circular(10),
                                            child: Stack(
                                              children: [
                                                _initialCameraPosition == null
                                                    ? const Center(
                                                        child: CircularProgressIndicator(
                                                            color: AppColor
                                                                .primaryColor)) // Show a loader until the position is ready
                                                    : GoogleMap(
                                                        initialCameraPosition:
                                                            _initialCameraPosition!,
                                                        minMaxZoomPreference:
                                                            const MinMaxZoomPreference(
                                                                0, 16),
                                                        compassEnabled: false,
                                                        indoorViewEnabled: true,
                                                        mapToolbarEnabled:
                                                            false,
                                                        zoomControlsEnabled:
                                                            true,
                                                        onMapCreated:
                                                            (GoogleMapController
                                                                controller) async {
                                                          await Geolocator
                                                              .requestPermission();
                                                          _mapController =
                                                              controller;
                                                          setState(() {
                                                            mapLoading = false;
                                                          });
                                                        },
                                                      ),
                                                if (!mapLoading)
                                                  Center(
                                                    child: Image.asset(
                                                      Images.markerBranch,
                                                      height: 50.h,
                                                      width: 50.w,
                                                    ),
                                                  ),
                                              ],
                                            ),
                                          ),
                                        ),
                                      ),
                                      if (cartController.orderTypeIndex == 1)
                                        Padding(
                                          padding: EdgeInsets.only(
                                              left: 16.w,
                                              right: 16.w,
                                              bottom: 30.h),
                                          child: Row(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              SvgPicture.asset(
                                                Images.locationIcon,
                                                fit: BoxFit.cover,
                                                height: 18.h,
                                                width: 18.h,
                                                color: AppColor.primaryColor,
                                              ),
                                              SizedBox(
                                                width: 4.w,
                                              ),
                                              SizedBox(
                                                width: Get.width - 55.w,
                                                child: Text(
                                                  box.read('branchAddress') ??
                                                      "",
                                                  style: fontProfileLite,
                                                  overflow:
                                                      TextOverflow.ellipsis,
                                                  maxLines: 2,
                                                ),
                                              ),
                                            ],
                                          ),
                                        )
                                    ],
                                  )
                                : const SizedBox.shrink(),

                            if (cartController.orderTypeIndex == 0)
                              GetBuilder<AddressController>(
                                builder: (addressController) => Padding(
                                  padding: EdgeInsets.only(
                                      left: 16.w, right: 16.w, bottom: 24.h),
                                  child: Column(
                                    children: [
                                      SizedBox(
                                        height: 32.h,
                                        child: Row(
                                            mainAxisAlignment:
                                                MainAxisAlignment.spaceBetween,
                                            children: [
                                              Text(
                                                "DELIVERY_ADDRESS".tr,
                                                style: fontMedium,
                                              ),
                                              Row(
                                                children: [
                                                  addressController
                                                          .addressDataList
                                                          .isNotEmpty
                                                      ? Container(
                                                          alignment:
                                                              Alignment.center,
                                                          padding:
                                                              EdgeInsets.only(
                                                                  left: 12.r,
                                                                  right: 12.r,
                                                                  top: 8.r,
                                                                  bottom: 8.r),
                                                          decoration:
                                                              BoxDecoration(
                                                            borderRadius:
                                                                BorderRadius
                                                                    .circular(
                                                                        16.r),
                                                            color: AppColor
                                                                .blueTransparent,
                                                          ),
                                                          child: InkWell(
                                                            onTap: () {
                                                              Get.to(() =>
                                                                  EditPickLocationView(
                                                                    addressData: addressController
                                                                            .addressDataList[
                                                                        addressController
                                                                            .checkoutAddressIndex],
                                                                  ));
                                                            },
                                                            child: Row(
                                                              mainAxisAlignment:
                                                                  MainAxisAlignment
                                                                      .center,
                                                              children: [
                                                                SvgPicture
                                                                    .asset(
                                                                  Images
                                                                      .iconEdit,
                                                                  fit: BoxFit
                                                                      .cover,
                                                                  height: 13.h,
                                                                  width: 13.h,
                                                                ),
                                                                SizedBox(
                                                                  width: 3.w,
                                                                ),
                                                                Text(
                                                                  "EDIT".tr,
                                                                  style:
                                                                      TextStyle(
                                                                    fontFamily:
                                                                        'Rubik',
                                                                    fontWeight:
                                                                        FontWeight
                                                                            .w500,
                                                                    fontSize:
                                                                        Dimensions
                                                                            .fontSizeSmall
                                                                            .sp,
                                                                    color: AppColor
                                                                        .blueTextColor,
                                                                  ),
                                                                ),
                                                              ],
                                                            ),
                                                          ),
                                                        )
                                                      : const SizedBox(),
                                                  SizedBox(
                                                    width: 12.w,
                                                  ),
                                                  Container(
                                                    alignment: Alignment.center,
                                                    padding: EdgeInsets.only(
                                                        left: 12.r,
                                                        right: 12.r,
                                                        top: 8.r,
                                                        bottom: 8.r),
                                                    decoration: BoxDecoration(
                                                      borderRadius:
                                                          BorderRadius.circular(
                                                              16.r),
                                                      color: AppColor.viewAllbg,
                                                    ),
                                                    child: InkWell(
                                                      onTap: () =>
                                                          _checkPermission(
                                                              () async {
                                                        Get.to(
                                                            AddPickLocationView());
                                                      }),
                                                      child: Row(
                                                        mainAxisAlignment:
                                                            MainAxisAlignment
                                                                .center,
                                                        children: [
                                                          SvgPicture.asset(
                                                            Images.iconAdd,
                                                            fit: BoxFit.cover,
                                                            height: 13.h,
                                                            width: 13.h,
                                                          ),
                                                          SizedBox(
                                                            width: 3.w,
                                                          ),
                                                          Text(
                                                            "ADD".tr,
                                                            style:
                                                                fontRegularBoldwithColor,
                                                          ),
                                                        ],
                                                      ),
                                                    ),
                                                  ),
                                                ],
                                              )
                                            ]),
                                      ),
                                      SizedBox(
                                        height: 12.h,
                                      ),
                                      addressController
                                              .addressDataList.isNotEmpty
                                          ? Container(
                                              alignment: Alignment.centerLeft,
                                              height: 100.h,
                                              child: ListView.builder(
                                                  shrinkWrap: true,
                                                  scrollDirection:
                                                      Axis.horizontal,
                                                  itemCount: addressController
                                                      .addressDataList.length,
                                                  itemBuilder:
                                                      (BuildContext context,
                                                          index) {
                                                    return Padding(
                                                      padding:
                                                          const EdgeInsets.only(
                                                              right: 10),
                                                      child: InkWell(
                                                        onTap: () async {
                                                          var distance = 0.0;

                                                          setState(() {
                                                            addressLat = double.parse(
                                                                addressController
                                                                    .addressDataList[
                                                                        index]
                                                                    .latitude
                                                                    .toString());

                                                            addressLon = double.parse(
                                                                addressController
                                                                    .addressDataList[
                                                                        index]
                                                                    .longitude
                                                                    .toString());

                                                            branchLat =
                                                                double.parse(box
                                                                    .read(
                                                                        'branchLat')
                                                                    .toString());
                                                            branchLong =
                                                                double.parse(box
                                                                    .read(
                                                                        'branchLong')
                                                                    .toString());

                                                            distance = Get.find<
                                                                    CartController>()
                                                                .calculateDistance(
                                                                    addressLat,
                                                                    addressLon,
                                                                    branchLat,
                                                                    branchLong);
                                                          });

                                                          await checkoutController
                                                              .checkDistance(
                                                            branchId: homeController
                                                                .selectedbranchId
                                                                .toString(),
                                                            distance: distance
                                                                .toString(),
                                                            latitude:
                                                                addressController
                                                                    .addressDataList[
                                                                        index]
                                                                    .latitude
                                                                    .toString(),
                                                            longitude:
                                                                addressController
                                                                    .addressDataList[
                                                                        index]
                                                                    .longitude
                                                                    .toString(),
                                                          )
                                                              .then((_) {
                                                            if (checkoutController
                                                                    .distanceModel
                                                                    .value
                                                                    .data
                                                                    ?.convertMinimumOrderAmount ==
                                                                null) {
                                                              // For set checkout address
                                                              if (checkoutController
                                                                  .isStatus) {
                                                                addressController
                                                                    .setAddress(
                                                                        index);
                                                                cartController
                                                                    .distanceWiseDeliveryCharge();
                                                                cartController
                                                                    .calculateTotal();
                                                              } else {
                                                                addressController
                                                                    .setAddress(
                                                                        -1);

                                                                cartController
                                                                    .calculateTotal();
                                                              }

                                                              checkoutController
                                                                  .getPaymentGateways();
                                                            } else {
                                                              if (checkoutController
                                                                      .distanceModel
                                                                      .value
                                                                      .data!
                                                                      .convertMinimumOrderAmount! >
                                                                  cartController
                                                                      .totalCartValue) {
                                                                addressController
                                                                    .checkoutAddressIndex = -1;
                                                                setState(() {});

                                                                if (checkoutController
                                                                    .isStatus) {
                                                                  customTast(
                                                                      "FOR_THIS_AREA_MINIMUM_ORDER_IS"
                                                                              .tr +
                                                                          " ${checkoutController.distanceModel.value.data!.currencyMinimumOrderAmount}"
                                                                              .tr,
                                                                      AppColor
                                                                          .error);
                                                                }

                                                                cartController
                                                                    .calculateTotal();
                                                                checkoutController
                                                                    .getPaymentGateways();
                                                              } else {
                                                                setState(() {
                                                                  if (checkoutController
                                                                      .isStatus) {
                                                                    addressController
                                                                        .setAddress(
                                                                            index);
                                                                    Get.find<CartController>().calculateDistanceWithMinimumOrder(checkoutController
                                                                            .distanceModel
                                                                            .value
                                                                            .data!
                                                                            .convertMinimumOrderAmount
                                                                            ?.toDouble() ??
                                                                        0.0);
                                                                    cartController
                                                                        .calculateTotal();
                                                                    checkoutController
                                                                        .getPaymentGateways();
                                                                  } else {
                                                                    addressController
                                                                        .setAddress(
                                                                            -1);

                                                                    cartController
                                                                        .calculateTotal();
                                                                  }
                                                                });
                                                              }
                                                            }
                                                          });
                                                        },
                                                        child: Container(
                                                          height: 80.h,
                                                          width: 158.w,
                                                          decoration:
                                                              BoxDecoration(
                                                            borderRadius:
                                                                BorderRadius
                                                                    .circular(
                                                                        8.r),
                                                            color: addressController
                                                                        .checkoutAddressIndex ==
                                                                    index
                                                                ? AppColor
                                                                    .primaryColor
                                                                    .withOpacity(
                                                                        0.08)
                                                                : AppColor
                                                                    .itembg,
                                                            border: addressController
                                                                        .checkoutAddressIndex ==
                                                                    index
                                                                ? Border.all(
                                                                    color: AppColor
                                                                        .primaryColor)
                                                                : Border.all(
                                                                    color: Colors
                                                                        .white),
                                                          ),
                                                          child: Column(
                                                            children: [
                                                              Row(
                                                                children: [
                                                                  SizedBox(
                                                                    width:
                                                                        130.w,
                                                                    child: Row(
                                                                      children: [
                                                                        Padding(
                                                                          padding: EdgeInsets.only(
                                                                              top: 8.w,
                                                                              left: 8.w,
                                                                              right: 8.h),
                                                                          child: addressController.addressDataList[index].label.toString() == "Home"
                                                                              ? SvgPicture.asset(
                                                                                  Images.homeIcon,
                                                                                  fit: BoxFit.cover,
                                                                                  height: 15.h,
                                                                                  width: 15.w,
                                                                                )
                                                                              : addressController.addressDataList[index].label.toString() == "Work"
                                                                                  ? SvgPicture.asset(
                                                                                      Images.work,
                                                                                      fit: BoxFit.cover,
                                                                                    )
                                                                                  : SvgPicture.asset(
                                                                                      Images.other,
                                                                                      fit: BoxFit.cover,
                                                                                    ),
                                                                        ),
                                                                        Padding(
                                                                          padding:
                                                                              EdgeInsets.only(top: 8.h),
                                                                          child:
                                                                              Text(
                                                                            addressController.addressDataList[index].label.toString(),
                                                                            style:
                                                                                TextStyle(
                                                                              fontFamily: 'Rubik',
                                                                              fontWeight: FontWeight.w500,
                                                                              fontSize: Dimensions.fontSizeDefault,
                                                                              color: AppColor.blueTextColor,
                                                                            ),
                                                                          ),
                                                                        ),
                                                                      ],
                                                                    ),
                                                                  ),
                                                                  Padding(
                                                                    padding: const EdgeInsets
                                                                        .only(
                                                                        top: 2,
                                                                        right:
                                                                            2),
                                                                    child:
                                                                        SizedBox(
                                                                      width:
                                                                          20.w,
                                                                      height:
                                                                          20.h,
                                                                      child: addressController.checkoutAddressIndex ==
                                                                              index
                                                                          ? SvgPicture
                                                                              .asset(
                                                                              Images.IconVariationSelected,
                                                                              fit: BoxFit.cover,
                                                                            )
                                                                          : SvgPicture
                                                                              .asset(
                                                                              Images.IconVariation,
                                                                              fit: BoxFit.cover,
                                                                            ),
                                                                    ),
                                                                  ),
                                                                ],
                                                              ),
                                                              Row(
                                                                children: [
                                                                  Expanded(
                                                                    child: Row(
                                                                      children: [
                                                                        Padding(
                                                                          padding: EdgeInsets.only(
                                                                              top: 8.h,
                                                                              left: 8.w,
                                                                              right: 8.w),
                                                                          child:
                                                                              SvgPicture.asset(
                                                                            Images.locationIcon,
                                                                            fit:
                                                                                BoxFit.cover,
                                                                          ),
                                                                        ),
                                                                        Flexible(
                                                                          child:
                                                                              Padding(
                                                                            padding:
                                                                                EdgeInsets.only(top: 8.h),
                                                                            child:
                                                                                Text(
                                                                              addressController.addressDataList[index].address.toString(),
                                                                              style: fontRegular,
                                                                              maxLines: 2,
                                                                              overflow: TextOverflow.ellipsis,
                                                                            ),
                                                                          ),
                                                                        ),
                                                                      ],
                                                                    ),
                                                                  ),
                                                                ],
                                                              ),
                                                              addressController
                                                                          .addressDataList[
                                                                              index]
                                                                          .apartment !=
                                                                      null
                                                                  ? Row(
                                                                      children: [
                                                                        Expanded(
                                                                          child:
                                                                              Padding(
                                                                            padding:
                                                                                const EdgeInsets.only(left: 28),
                                                                            child:
                                                                                Row(
                                                                              children: [
                                                                                Flexible(
                                                                                  child: Padding(
                                                                                    padding: EdgeInsets.only(top: 8.h),
                                                                                    child: Text(
                                                                                      addressController.addressDataList[index].apartment.toString(),
                                                                                      style: fontRegular,
                                                                                      maxLines: 1,
                                                                                      overflow: TextOverflow.ellipsis,
                                                                                    ),
                                                                                  ),
                                                                                ),
                                                                              ],
                                                                            ),
                                                                          ),
                                                                        ),
                                                                      ],
                                                                    )
                                                                  : const SizedBox(),
                                                            ],
                                                          ),
                                                        ),
                                                      ),
                                                    );
                                                  }),
                                            )
                                          : InkWell(
                                              onTap: () {
                                                Get.to(AddPickLocationView());
                                              },
                                              child: Container(
                                                height: 60.h,
                                                width: double.infinity,
                                                decoration: BoxDecoration(
                                                    borderRadius:
                                                        BorderRadius.circular(
                                                            8.r),
                                                    color: AppColor.primaryColor
                                                        .withOpacity(0.08),
                                                    border: Border.all(
                                                        color: AppColor
                                                            .primaryColor)),
                                                child: Center(
                                                    child: Text(
                                                  "PLEASE_ADD_DELIVERY_ADDRESS"
                                                      .tr,
                                                  style: fontRegularBold,
                                                )),
                                              ),
                                            )
                                    ],
                                  ),
                                ),
                              ),

                            //preference time to delivery
                            GetBuilder<CheckoutController>(
                              builder: (checkoutController) => Padding(
                                padding: EdgeInsets.only(
                                    left: 16.w, bottom: 24.w, right: 8.w),
                                child: Column(
                                  children: [
                                    Row(
                                      children: [
                                        Padding(
                                          padding: EdgeInsets.only(right: 8.w),
                                          child: Text(
                                            "PREFERENCE_TIME_TO_DELIVERY".tr,
                                            style: fontMedium,
                                          ),
                                        ),
                                      ],
                                    ),
                                    SizedBox(
                                      height: 12.h,
                                    ),
                                    Row(
                                      children: [
                                        SizedBox(
                                          height: 40.h,
                                          child: ListView.builder(
                                              scrollDirection: Axis.horizontal,
                                              shrinkWrap: true,
                                              physics:
                                                  const BouncingScrollPhysics(),
                                              itemCount: 2,
                                              itemBuilder: (context, index) {
                                                return TimeSlotWidget(
                                                  title: index == 0
                                                      ? 'TODAY'.tr
                                                      : 'TOMORROW'.tr,
                                                  isSelected: checkoutController
                                                          .selectDateSlot ==
                                                      index,
                                                  onTap: () {
                                                    checkoutController
                                                        .updateDateSlot(index);
                                                  },
                                                );
                                              }),
                                        ),
                                        SizedBox(
                                          width: 12.w,
                                        ),
                                      ],
                                    ),
                                    SizedBox(
                                      height: 8.h,
                                    ),
                                    if (checkoutController.selectDateSlot == 0)
                                      Container(
                                          alignment: Alignment.centerLeft,
                                          height: 40.h,
                                          child: checkoutController
                                                      .todayDataList !=
                                                  null
                                              ? checkoutController
                                                      .todayDataList.isNotEmpty
                                                  ? ListView.builder(
                                                      scrollDirection:
                                                          Axis.horizontal,
                                                      shrinkWrap: true,
                                                      physics:
                                                          const BouncingScrollPhysics(),
                                                      itemCount:
                                                          checkoutController
                                                              .todayDataList
                                                              .length,
                                                      itemBuilder:
                                                          (context, index) {
                                                        return TimeSlotWidget(
                                                          title: (index == 0 &&
                                                                  checkoutController
                                                                          .selectDateSlot ==
                                                                      0
                                                              ? 'NOW'.tr
                                                              : checkoutController
                                                                  .todayDataList[
                                                                      index]
                                                                  .label!),
                                                          isSelected:
                                                              checkoutController
                                                                      .selectTimeSlot ==
                                                                  index,
                                                          onTap: () {
                                                            checkoutController
                                                                    .selectedDate =
                                                                checkoutController
                                                                    .todayDataList[
                                                                        index]
                                                                    .time!;
                                                            isAdvanceOrder = 10;
                                                            checkoutController
                                                                .updateTimeSlot(
                                                                    index);
                                                          },
                                                        );
                                                      },
                                                    )
                                                  : Container(
                                                      height: 60.h,
                                                      width: double.infinity,
                                                      decoration: BoxDecoration(
                                                          borderRadius:
                                                              BorderRadius
                                                                  .circular(
                                                                      8.r),
                                                          color: AppColor
                                                              .primaryColor
                                                              .withOpacity(
                                                                  0.08),
                                                          border: Border.all(
                                                              color: AppColor
                                                                  .primaryColor)),
                                                      child: Center(
                                                          child: Text(
                                                        "CURRENTLY_NOT_ACCEPTING_ANY_ORDER"
                                                            .tr,
                                                        style: fontRegularBold,
                                                      )),
                                                    )
                                              : const Center(
                                                  child:
                                                      CircularProgressIndicator())),
                                    if (checkoutController.selectDateSlot == 1)
                                      Container(
                                          alignment: Alignment.centerLeft,
                                          height: 40.h,
                                          child: checkoutController
                                                      .tomorrowDataList !=
                                                  null
                                              ? checkoutController
                                                      .tomorrowDataList
                                                      .isNotEmpty
                                                  ? ListView.builder(
                                                      scrollDirection:
                                                          Axis.horizontal,
                                                      shrinkWrap: true,
                                                      physics:
                                                          const BouncingScrollPhysics(),
                                                      itemCount:
                                                          checkoutController
                                                              .tomorrowDataList
                                                              .length,
                                                      itemBuilder:
                                                          (context, index) {
                                                        return TimeSlotWidget(
                                                          title: checkoutController
                                                              .tomorrowDataList[
                                                                  index]
                                                              .label!,
                                                          isSelected:
                                                              checkoutController
                                                                      .selectTimeSlot ==
                                                                  index,
                                                          onTap: () {
                                                            checkoutController
                                                                    .selectedDate =
                                                                checkoutController
                                                                    .tomorrowDataList[
                                                                        index]
                                                                    .time!;
                                                            isAdvanceOrder = 5;
                                                            checkoutController
                                                                .updateTimeSlot(
                                                                    index);
                                                          },
                                                        );
                                                      },
                                                    )
                                                  : Container(
                                                      height: 60.h,
                                                      width: double.infinity,
                                                      decoration: BoxDecoration(
                                                          borderRadius:
                                                              BorderRadius
                                                                  .circular(
                                                                      8.r),
                                                          color: AppColor
                                                              .primaryColor
                                                              .withOpacity(
                                                                  0.08),
                                                          border: Border.all(
                                                              color: AppColor
                                                                  .primaryColor)),
                                                      child: Center(
                                                          child: Text(
                                                        "NOT_ACCEPTING_ANY_ORDER"
                                                            .tr,
                                                        style: fontRegularBold,
                                                      )),
                                                    )
                                              : const Center(
                                                  child:
                                                      CircularProgressIndicator())),
                                  ],
                                ),
                              ),
                            ),
                            /*-------------------------[START - TIP RIDER]--------------------------- */

                            Obx(
                              () =>
                                  checkoutController
                                                  .selectPaymentMethod.value ==
                                              0 ||
                                          checkoutController
                                                  .selectPaymentMethod.value ==
                                              -1 ||
                                          cartController.orderTypeIndex == 1
                                      ? const SizedBox()
                                      : Container(
                                          height: 160.h,
                                          width: double.infinity,
                                          decoration: BoxDecoration(
                                            borderRadius:
                                                BorderRadius.circular(16.r),
                                            color: Colors.white,
                                            boxShadow: const [
                                              BoxShadow(
                                                  color: AppColor.fontColor),
                                            ],
                                          ),
                                          child: Padding(
                                            padding: EdgeInsets.only(
                                                left: 16.w,
                                                top: 16.w,
                                                bottom: 16.h),
                                            child: Column(
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              children: [
                                                TextWidget(
                                                  text: "TIP_YOUR_RIDER".tr,
                                                  fontSize: 16.sp,
                                                  fontWeight: FontWeight.w500,
                                                ),
                                                SizedBox(height: 8.h),
                                                TextWidget(
                                                    text:
                                                        "100% of the tips go to your rider, we don't deduct anything from it.",
                                                    fontSize: 14.sp,
                                                    fontWeight:
                                                        FontWeight.w400),
                                                SizedBox(height: 12.h),
                                                Obx(
                                                  () =>
                                                      checkoutController
                                                                  .tipsModel
                                                                  .value
                                                                  .data ==
                                                              null
                                                          ? const SizedBox()
                                                          : Expanded(
                                                              child: SizedBox(
                                                                child: ListView
                                                                    .builder(
                                                                        scrollDirection:
                                                                            Axis
                                                                                .horizontal,
                                                                        shrinkWrap:
                                                                            true,
                                                                        itemCount: checkoutController
                                                                            .tipsModel
                                                                            .value
                                                                            .data
                                                                            ?.length,
                                                                        itemBuilder:
                                                                            (context,
                                                                                index) {
                                                                          final tips = checkoutController
                                                                              .tipsModel
                                                                              .value
                                                                              .data?[index];
                                                                          return GestureDetector(
                                                                            onTap:
                                                                                () {
                                                                              checkoutController.selectedTipIndex.value = index;
                                                                              cartController.calculateTotal();
                                                                              checkoutController.getPaymentGateways();
                                                                            },
                                                                            child:
                                                                                Obx(
                                                                              () => Padding(
                                                                                padding: EdgeInsets.only(right: 8.w),
                                                                                child: Container(
                                                                                  // height: 36.h,
                                                                                  width: 71.w,
                                                                                  decoration: BoxDecoration(borderRadius: BorderRadius.circular(24.r), border: Border.all(color: checkoutController.selectedTipIndex.value == index ? AppColor.primaryColor : Colors.transparent), color: checkoutController.selectedTipIndex.value == index ? AppColor.primaryColor.withOpacity(0.08) : AppColor.bgColor),
                                                                                  child: Center(
                                                                                    child: TextWidget(
                                                                                      text: tips?.currencyAmount ?? "",
                                                                                      fontWeight: FontWeight.w400,
                                                                                      fontSize: 12.sp,
                                                                                    ),
                                                                                  ),
                                                                                ),
                                                                              ),
                                                                            ),
                                                                          );
                                                                        }),
                                                              ),
                                                            ),
                                                )
                                              ],
                                            ),
                                          ),
                                        ),
                            ),
                            /*-------------------------[END - TIP RIDER]--------------------------- */

                            /*------------------[ START - Payment Method ]-------------------- */
                            SizedBox(height: 24.h),
                            Padding(
                              padding: EdgeInsets.symmetric(horizontal: 16.w),
                              child: Row(
                                children: [
                                  TextWidget(
                                      text: "PAYMENT_METHOD".tr,
                                      fontSize: 16.sp,
                                      fontWeight: FontWeight.w500),
                                ],
                              ),
                            ),
                            SizedBox(height: 16.h),
                            divider(),
                            SizedBox(height: 16.h),

                            Obx(
                              () {
                                double balance = double.parse(
                                    profileController.profileData.balance ??
                                        "0");

                                // final filteredPaymentList = checkoutController
                                //     .paymentModel.value.data
                                //     ?.where((payment) =>
                                //         !((payment.name == 'Credit') &&
                                //             (balance == 0 ||
                                //                 cartController.total >= balance)))
                                //     .toList();

                                return checkoutController
                                                .paymentModel.value.data ==
                                            null ||
                                        checkoutController
                                                .selectPaymentMethod.value ==
                                            -2
                                    ? const SizedBox()
                                    : Padding(
                                        padding: EdgeInsets.symmetric(
                                            horizontal: 16.w),
                                        child: SizedBox(
                                          child: StaggeredGridView.countBuilder(
                                            shrinkWrap: true,
                                            crossAxisCount: 2,
                                            crossAxisSpacing: 16.w,
                                            mainAxisSpacing: 16.h,
                                            physics:
                                                const NeverScrollableScrollPhysics(),
                                            staggeredTileBuilder: (int index) =>
                                                const StaggeredTile.fit(1),
                                            itemCount: checkoutController
                                                    .paymentModel
                                                    .value
                                                    .data
                                                    ?.length ??
                                                0,
                                            itemBuilder: (context, index) {
                                              final data = checkoutController
                                                  .paymentModel.value.data;

                                              if (data?[index].name ==
                                                      "Credit" &&
                                                  (balance == 0 ||
                                                      cartController.total >
                                                          balance)) {
                                                if (checkoutController
                                                        .selectPaymentMethod
                                                        .value ==
                                                    index) {
                                                  checkoutController
                                                      .paymentMethodSlug = "";

                                                  WidgetsBinding.instance
                                                      .addPostFrameCallback(
                                                          (_) {
                                                    checkoutController
                                                            .selectPaymentMethod
                                                            .value =
                                                        -1; // Reset payment selection
                                                  });
                                                }
                                                return const SizedBox();
                                              }
                                              return GestureDetector(
                                                onTap: () {
                                                  checkoutController
                                                      .selectPaymentMethod
                                                      .value = index;

                                                  checkoutController
                                                          .paymentMethodId =
                                                      data?[index].id;

                                                  checkoutController
                                                          .paymentMethodSlug =
                                                      data?[index].slug ?? "";

                                                  if (index == 0) {
                                                    checkoutController
                                                        .selectedTipIndex
                                                        .value = -1;
                                                  }
                                                },
                                                child: Container(
                                                  width: 156.w,
                                                  decoration: BoxDecoration(
                                                    borderRadius:
                                                        BorderRadius.circular(
                                                            8.r),
                                                    border: Border.all(
                                                      color: checkoutController
                                                                  .selectPaymentMethod
                                                                  .value ==
                                                              index
                                                          ? AppColor
                                                              .primaryColor
                                                          : Colors.white,
                                                    ),
                                                    color: checkoutController
                                                                .selectPaymentMethod
                                                                .value ==
                                                            index
                                                        ? AppColor
                                                            .primaryBackgroundColor
                                                        : Colors.white,
                                                  ),
                                                  child: Padding(
                                                    padding: EdgeInsets.only(
                                                        top: 10.h,
                                                        bottom: 10.h),
                                                    child: Column(
                                                      mainAxisAlignment:
                                                          MainAxisAlignment
                                                              .center,
                                                      crossAxisAlignment:
                                                          CrossAxisAlignment
                                                              .center,
                                                      children: [
                                                        SizedBox(height: 8.h),
                                                        CachedNetworkImage(
                                                          imageUrl: data?[index]
                                                                  .image ??
                                                              "",
                                                          height: 24.h,
                                                          width: 40.w,
                                                        ),
                                                        SizedBox(height: 8.h),
                                                        Row(
                                                          mainAxisAlignment:
                                                              MainAxisAlignment
                                                                  .center,
                                                          children: [
                                                            TextWidget(
                                                                text:
                                                                    "${data?[index].name}"),
                                                            if (data?[index]
                                                                    .name ==
                                                                "Credit") ...[
                                                              TextWidget(
                                                                text:
                                                                    " (${profileController.profileData.balance})",
                                                              ),
                                                            ],
                                                          ],
                                                        )
                                                      ],
                                                    ),
                                                  ),
                                                ),
                                              );
                                            },
                                          ),
                                        ),
                                      );
                              },
                            ),

                            /*-------------------------[END - Payment Method]--------------------------- */

                            Padding(
                              padding: EdgeInsets.only(
                                  left: 16.w,
                                  right: 16.w,
                                  top: 10.h,
                                  bottom: 10.h),
                              child: Row(
                                mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                children: [
                                  Text(
                                    "CART_SUMMARY".tr,
                                    style: TextStyle(
                                      fontFamily: 'Rubik',
                                      fontSize: 16.sp,
                                      fontWeight: FontWeight.w600,
                                    ),
                                  ),
                                  if (splashController
                                              .configData.orderSetupDelivery ==
                                          5 &&
                                      splashController
                                              .configData.orderSetupTakeaway ==
                                          5)
                                    Padding(
                                      padding: const EdgeInsets.all(8.0),
                                      child: SizedBox(
                                        child: ToggleSwitch(
                                          minWidth: 90.w,
                                          cornerRadius: 20.r,
                                          activeBgColors: const [
                                            [AppColor.delivaryActive],
                                            [AppColor.delivaryActive],
                                          ],
                                          activeFgColor: Colors.white,
                                          inactiveBgColor:
                                              AppColor.delivaryInactive,
                                          inactiveFgColor: Colors.white,
                                          initialLabelIndex:
                                              cartController.orderTypeIndex,
                                          customTextStyles: [
                                            fontMediumProWhite
                                          ],
                                          totalSwitches: 2,
                                          labels: [
                                            'DELIVERY'.tr,
                                            'TAKEAWAY'.tr
                                          ],
                                          radiusStyle: true,
                                          onToggle: (index) {
                                            setState(() {
                                              cartController
                                                  .setDerliveryTakewayButton(
                                                      index);
                                              if (cartController
                                                      .orderTypeIndex ==
                                                  1) {
                                                checkoutController
                                                    .selectedTipIndex
                                                    .value = -1;
                                              }
                                              cartController
                                                  .distanceWiseDeliveryCharge();
                                              cartController.calculateTotal();
                                              checkoutController
                                                  .getPaymentGateways();
                                            });
                                          },
                                        ),
                                      ),
                                    ),
                                  if (splashController
                                              .configData.orderSetupDelivery ==
                                          5 &&
                                      splashController
                                              .configData.orderSetupTakeaway ==
                                          10)
                                    Padding(
                                      padding: const EdgeInsets.all(8.0),
                                      child: SizedBox(
                                        child: ToggleSwitch(
                                          minWidth: 90.w,
                                          cornerRadius: 20.r,
                                          activeBgColors: const [
                                            [AppColor.delivaryActive],
                                          ],
                                          activeFgColor: Colors.white,
                                          inactiveBgColor:
                                              AppColor.delivaryInactive,
                                          inactiveFgColor: Colors.white,
                                          initialLabelIndex:
                                              cartController.orderTypeIndex,
                                          customTextStyles: [
                                            fontMediumProWhite
                                          ],
                                          totalSwitches: 1,
                                          labels: ['DELIVERY'.tr],
                                          radiusStyle: true,
                                        ),
                                      ),
                                    ),
                                  if (splashController
                                              .configData.orderSetupDelivery ==
                                          10 &&
                                      splashController
                                              .configData.orderSetupTakeaway ==
                                          5)
                                    Padding(
                                      padding: const EdgeInsets.all(8.0),
                                      child: SizedBox(
                                        child: ToggleSwitch(
                                          minWidth: 90.w,
                                          cornerRadius: 20.r,
                                          activeBgColors: const [
                                            [AppColor.delivaryActive],
                                          ],
                                          activeFgColor: Colors.white,
                                          inactiveBgColor:
                                              AppColor.delivaryInactive,
                                          inactiveFgColor: Colors.white,
                                          initialLabelIndex:
                                              cartController.orderTypeIndex,
                                          customTextStyles: [
                                            fontMediumProWhite
                                          ],
                                          totalSwitches: 1,
                                          labels: ['TAKEAWAY'.tr],
                                          radiusStyle: true,
                                        ),
                                      ),
                                    ),
                                ],
                              ),
                            ),

                            cartSummarySection(context),
                          ],
                        ),
                      ),
                    ),
                  ),
                  Positioned(
                    bottom: 0,
                    child: Container(
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(16.r),
                        color: Colors.white,
                        boxShadow: [
                          BoxShadow(
                            color: AppColor.itembg.withOpacity(1),
                            offset: const Offset(
                              6.0,
                              0.0,
                            ),
                            blurRadius: 10.0,
                            spreadRadius: 2,
                          ), //BoxShadow
                        ],
                      ),
                      child: Padding(
                        padding: EdgeInsets.symmetric(
                            horizontal: 16.w, vertical: 16),
                        child: GetBuilder<PlaceOrderController>(
                          builder: (placeOrderController) => Row(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              ElevatedButton(
                                onPressed: () async {
                                  setState(() {
                                    if (splashController.configData
                                                .orderSetupDelivery ==
                                            10 &&
                                        splashController.configData
                                                .orderSetupTakeaway ==
                                            10) {
                                      customTast(
                                          "CURRENTLY_NOT_ACCEPTING_ANY_ORDER"
                                              .tr,
                                          AppColor.error);
                                    } else if (addressController
                                            .addressDataList.isEmpty &&
                                        cartController.orderTypeIndex == 0) {
                                      customTast(
                                          "PLEASE_ADD_DELIVERY_ADDRESS".tr,
                                          AppColor.error);
                                    } else if (addressController
                                                .checkoutAddressIndex ==
                                            -1 &&
                                        cartController.orderTypeIndex == 0) {
                                      customTast("PLEASE_CHOOSE_AN_ADDRESS".tr,
                                          AppColor.error);
                                    } else {
                                      if (checkoutController
                                              .selectPaymentMethod.value !=
                                          -1) {
                                        placeOrderController.placeOrderPost(
                                            PlaceOrderBody(
                                              branchId: homeController
                                                  .selectedbranchId,
                                              orderType: cartController
                                                          .orderTypeIndex ==
                                                      0
                                                  ? 5
                                                  : 10,
                                              isAdvanceOrder: isAdvanceOrder,
                                              riderTip: checkoutController
                                                          .selectedTipIndex
                                                          .value ==
                                                      -1
                                                  ? 0.0
                                                  : double.parse(checkoutController
                                                      .tipsModel
                                                      .value
                                                      .data![checkoutController
                                                          .selectedTipIndex
                                                          .value]
                                                      .convertAmount
                                                      .toString()),
                                              deliveryCharge: cartController
                                                          .orderTypeIndex ==
                                                      1
                                                  ? 0.0
                                                  : checkoutController
                                                              .distanceModel
                                                              .value
                                                              .data
                                                              ?.convertMinimumOrderAmount ==
                                                          null
                                                      ? cartController
                                                          .deliveryCharge
                                                      : double.parse(
                                                          checkoutController
                                                                  .distanceModel
                                                                  .value
                                                                  .data!
                                                                  .flatDeliveryCharge ??
                                                              ""),
                                              distance:
                                                  cartController.kilometer,
                                              addressId: cartController
                                                          .orderTypeIndex ==
                                                      0
                                                  ? addressController
                                                      .addressDataList[
                                                          addressController
                                                              .checkoutAddressIndex]
                                                      .id
                                                  : null,
                                              deliveryTime: checkoutController
                                                  .selectedDate,
                                              subtotal:
                                                  cartController.totalCartValue,
                                              pointsAmount: double.parse(
                                                  checkoutController
                                                          .isPointApply.value
                                                      ? checkoutController
                                                          .pointsModel
                                                          .value
                                                          .data!
                                                          .pointDiscountAmount
                                                          .toString()
                                                      : "0"),
                                              total: cartController.total,
                                              couponId: cartController.couponId,
                                              discount:
                                                  cartController.couponDiscount,
                                              source: 10,
                                              items: cartController.cart,
                                            ),
                                            // callback,
                                            paymentSlug: checkoutController
                                                .paymentMethodSlug);
                                      } else {
                                        customTast(
                                            "PLEASE_SELECT_PAYMENT_METHOD".tr,
                                            AppColor.error);
                                      }
                                    }
                                  });
                                },
                                style: ElevatedButton.styleFrom(
                                  elevation: 0,
                                  backgroundColor: AppColor.primaryColor,
                                  minimumSize: Size(328.w, 52.h),
                                  shape: RoundedRectangleBorder(
                                    borderRadius: BorderRadius.circular(24.r),
                                  ),
                                ),
                                child: Text(
                                  "PLACE_ORDER".tr,
                                  style: fontMedium,
                                ),
                              ),
                            ],
                          ),
                        ),
                      ),
                    ),
                  ),
                ],
              )),
          placeOrderController.loader
              ? Positioned(
                  child: Container(
                    height: MediaQuery.of(context).size.height,
                    width: MediaQuery.of(context).size.width,
                    color: Colors.white60,
                    child: const Center(
                      child: LoaderCircle(),
                    ),
                  ),
                )
              : const SizedBox.shrink(),
        ],
      ),
    );
  }

  void _checkPermission(Function onTap) async {
    LocationPermission permission = await Geolocator.checkPermission();
    if (permission == LocationPermission.denied) {
      permission = await Geolocator.requestPermission();
    }
    if (permission == LocationPermission.denied) {
      customSnackbar("ERROR".tr, "LOCATION_SERVICE_DENIED".tr, AppColor.error);
    } else if (permission == LocationPermission.deniedForever) {
      permissionAlert(context).show();
    } else {
      onTap();
    }
  }
}

Widget cartSummarySection(context) {
  SplashController splashController = Get.put(SplashController());
  CheckoutController checkoutController = Get.put(CheckoutController());
  final addressController = Get.put(AddressController());

  return GetBuilder<CartController>(
    builder: (cartController) => Padding(
      padding: EdgeInsets.only(left: 16.w, right: 16.w, bottom: 100.h),
      child: Container(
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(16.r),
          color: Colors.white,
          boxShadow: [
            BoxShadow(
              color: AppColor.itembg,
              offset: const Offset(
                0.0,
                0.0,
              ),
              blurRadius: 5.0.r,
              spreadRadius: 1.0.r,
            ),
          ],
        ),
        child: Column(
          children: [
            Padding(
              padding: EdgeInsets.only(top: 24.h, left: 6.w, right: 12.w),
              child: ListView.builder(
                primary: false,
                shrinkWrap: true,
                itemCount: cartController.cart.length,
                itemBuilder: (BuildContext context, index) {
                  return Column(
                    children: [
                      SizedBox(
                        child: Row(children: [
                          Stack(
                            children: [
                              Padding(
                                padding: EdgeInsets.only(left: 8.w, right: 8.w),
                                child: SizedBox(
                                  width: 70.w,
                                  height: 70.h,
                                  child: ClipRRect(
                                    borderRadius:
                                        BorderRadius.all(Radius.circular(8.r)),
                                    child: CachedNetworkImage(
                                      imageUrl:
                                          cartController.cart[index].itemImage!,
                                      imageBuilder: (context, imageProvider) =>
                                          Container(
                                        decoration: BoxDecoration(
                                          image: DecorationImage(
                                            image: imageProvider,
                                            fit: BoxFit.cover,
                                          ),
                                        ),
                                      ),
                                      placeholder: (context, url) =>
                                          Shimmer.fromColors(
                                        child: Container(
                                            height: 130.h,
                                            width: 200.w,
                                            color: Colors.grey),
                                        baseColor: Colors.grey[300]!,
                                        highlightColor: Colors.grey[400]!,
                                      ),
                                      errorWidget: (context, url, error) =>
                                          const Icon(Icons.error),
                                    ),
                                  ),
                                ),
                              ),
                              Positioned(
                                top: 22.h,
                                child: ClipRRect(
                                  borderRadius:
                                      BorderRadius.circular(20.r), //or 15.0
                                  child: Container(
                                    height: 20.h,
                                    width: 20.w,
                                    color: AppColor.fontColor,
                                    child: Align(
                                      alignment: Alignment.center,
                                      child: Text(
                                        cartController.cart[index].quantity!
                                            .toString(),
                                        style: const TextStyle(
                                            color: Colors.white),
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                            ],
                          ),
                          SizedBox(
                            width: 4.w,
                          ),
                          SizedBox(
                            height: 70.h,
                            width: 210.w,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Text(
                                  cartController.cart[index].itemName!,
                                  style: TextStyle(
                                      fontSize: 14.sp,
                                      fontWeight: FontWeight.w500),
                                  maxLines: 1,
                                  overflow: TextOverflow.ellipsis,
                                ),
                                SizedBox(
                                  height: 2.h,
                                ),
                                cartController.cart[index].itemVariations !=
                                        null
                                    ? SizedBox(
                                        width: 240.w,
                                        height: 20.h,
                                        child: ListView.builder(
                                          scrollDirection: Axis.horizontal,
                                          shrinkWrap: true,
                                          itemCount: cartController.cart[index]
                                              .itemVariations!.length,
                                          itemBuilder:
                                              (BuildContext context, i) {
                                            return Text(
                                              index ==
                                                      cartController
                                                              .cart[index]
                                                              .itemVariations!
                                                              .length -
                                                          1
                                                  ? "${cartController.cart[index].itemVariations![i].variationName} : ${cartController.cart[index].itemVariations![i].name}."
                                                  : "${cartController.cart[index].itemVariations![i].variationName} : ${cartController.cart[index].itemVariations![i].name}, ",
                                              style: TextStyle(
                                                  fontFamily: 'Rubik',
                                                  fontSize: 12.sp,
                                                  fontWeight: FontWeight.w400,
                                                  color: AppColor.gray),
                                              overflow: TextOverflow.ellipsis,
                                              maxLines: 2,
                                            );
                                          },
                                        ),
                                      )
                                    : const SizedBox.shrink(),
                                SizedBox(
                                  height: 4.h,
                                ),
                                Get.find<SplashController>()
                                            .configData
                                            .siteCurrencyPosition ==
                                        5
                                    ? Row(
                                        children: [
                                          Text(
                                            Get.find<SplashController>()
                                                .configData
                                                .siteDefaultCurrencySymbol!,
                                            style: fontMediumPro,
                                          ),
                                          Text(
                                            cartController
                                                .cart[index].totalPrice!
                                                .toStringAsFixed(2),
                                            style: fontMediumPro,
                                          ),
                                        ],
                                      )
                                    : Row(
                                        children: [
                                          Text(
                                            cartController
                                                .cart[index].totalPrice!
                                                .toString(),
                                            style: fontMediumPro,
                                          ),
                                          Text(
                                            Get.find<SplashController>()
                                                .configData
                                                .siteDefaultCurrencySymbol!,
                                            style: fontMediumPro,
                                          ),
                                        ],
                                      ),
                              ],
                            ),
                          ),
                        ]),
                      ),
                      Padding(
                        padding: EdgeInsets.only(left: 10.w),
                        child: cartVariationSection(index),
                      ),
                      Padding(
                        padding: EdgeInsets.only(left: 10.w),
                        child: cartInstructionSection(index),
                      ),
                      const Divider(),
                    ],
                  );
                },
              ),
            ),
            /*--------- [ Start Points ] ---------*/
            Obx(
              () => checkoutController.pointsModel.value.data == null ||
                      checkoutController
                              .pointsModel.value.data!.isPointApplicable ==
                          false
                  ? const SizedBox()
                  : Padding(
                      padding:
                          EdgeInsets.symmetric(horizontal: 12.w, vertical: 8.h),
                      child: Row(
                        children: [
                          Column(
                            children: [
                              SvgPicture.asset(
                                Images.cutlery,
                                height: 24.h,
                              )
                            ],
                          ),
                          SizedBox(width: 12.w),
                          Expanded(
                            flex: 6,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                TextWidget(
                                    text: "APPLY_POINTS".tr,
                                    fontSize: 14.sp,
                                    fontWeight: FontWeight.w500),
                                SizedBox(height: 8.h),
                                Obx(
                                  () => checkoutController.isPointApply.value
                                      ? TextWidget(
                                          text: 'applied_point'.trParams({
                                          'applicablePoint':
                                              '${checkoutController.pointsModel.value.data?.applicablePoints ?? 0}',
                                          // Fallback to 0 if null

                                          'amount':
                                              '${checkoutController.pointsModel.value.data?.currencyPointDiscountAmount ?? 0}',

                                          'remainingPoint':
                                              '${checkoutController.pointsModel.value.data!.userPoints! - checkoutController.pointsModel.value.data!.applicablePoints!}'
                                        }))
                                      : TextWidget(
                                          text: 'points_info'.trParams({
                                            'userPoints':
                                                '${checkoutController.pointsModel.value.data?.userPoints ?? 0}',
                                            // Fallback to 0 if null

                                            'applicablePoint':
                                                '${checkoutController.pointsModel.value.data?.applicablePoints}',
                                            'amount':
                                                '${checkoutController.pointsModel.value.data?.currencyPointDiscountAmount ?? 0}', // Fallback to 0 if null
                                          }),
                                          fontSize: 12.sp,
                                          maxLines: 3,
                                          fontWeight: FontWeight.w400,
                                        ),
                                ),
                              ],
                            ),
                          ),
                          const Spacer(),
                          Column(
                            children: [
                              Obx(
                                () => SizedBox(
                                  height: 32.h,
                                  child: FittedBox(
                                    child: Switch(
                                        activeColor: AppColor.primaryColor,
                                        inactiveThumbColor:
                                            Colors.grey.shade100,
                                        inactiveTrackColor:
                                            AppColor.fontColor.withOpacity(.4),
                                        value: checkoutController
                                            .isPointApply.value,
                                        onChanged: (active) {
                                          if (double.parse(checkoutController
                                                  .pointsModel
                                                  .value
                                                  .data!
                                                  .pointDiscountAmount
                                                  .toString()) >=
                                              cartController.totalCartValue) {
                                            customSnackbar(
                                                "INFO".tr,
                                                "SUBTOTAL_SHOULD_BE_GREATER_THAN_DISCOUNT_AMOUNT"
                                                    .tr,
                                                AppColor.primaryColor);
                                          } else {
                                            checkoutController
                                                .isPointApply.value = active;
                                            cartController.calculateTotal();
                                            checkoutController
                                                .getPaymentGateways();
                                          }
                                        }),
                                  ),
                                ),
                              )
                            ],
                          ),
                        ],
                      ),
                    ),
            ),
            /*--------- [ End Points] ---------*/
            SizedBox(height: 16.h),
            ApplyOfferCard(splashController: splashController),
            Padding(
              padding: EdgeInsets.only(
                  left: 12.w, right: 12.w, top: 16.h, bottom: 12.h),
              child: Container(
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(12.r),
                    border: Border.all(color: AppColor.itembg)),
                child: Column(
                  children: [
                    Padding(
                      padding: EdgeInsets.all(8.r),
                      child: Row(
                        children: [
                          Text(
                            'SUBTOTAL'.tr,
                            style: fontRegularLite,
                          ),
                          const Spacer(),
                          Row(
                            children: [
                              if (splashController
                                      .configData.siteCurrencyPosition ==
                                  5)
                                Text(
                                  splashController.configData
                                          .siteDefaultCurrencySymbol ??
                                      "",
                                  style: fontRegularLite,
                                ),
                              Text(
                                cartController.totalCartValue.toStringAsFixed(
                                    int.parse(splashController.configData
                                            .siteDigitAfterDecimalPoint ??
                                        "2")),
                                style: fontRegularLite,
                              ),
                              if (splashController
                                      .configData.siteCurrencyPosition ==
                                  10)
                                Text(
                                  splashController.configData
                                          .siteDefaultCurrencySymbol ??
                                      "",
                                  style: fontRegularLite,
                                ),
                            ],
                          ),
                        ],
                      ),
                    ),
                    GetBuilder<CouponController>(
                      builder: (couponController) => Padding(
                        padding: EdgeInsets.all(8.0.r),
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Text(
                              'DISCOUNT'.tr,
                              style: fontRegularLite,
                            ),
                            Row(
                              children: [
                                if (splashController
                                        .configData.siteCurrencyPosition ==
                                    5)
                                  Text(
                                    splashController.configData
                                            .siteDefaultCurrencySymbol ??
                                        "",
                                    style: fontRegularLite,
                                  ),
                                Text(
                                  cartController.couponDiscount.toStringAsFixed(
                                      int.parse(splashController.configData
                                              .siteDigitAfterDecimalPoint ??
                                          "2")),
                                  style: fontRegularLite,
                                ),
                                if (splashController
                                        .configData.siteCurrencyPosition ==
                                    10)
                                  Text(
                                    splashController.configData
                                            .siteDefaultCurrencySymbol ??
                                        "",
                                    style: fontRegularLite,
                                  ),
                              ],
                            ),
                          ],
                        ),
                      ),
                    ),
                    Obx(
                      () => checkoutController.isPointApply.value
                          ? Padding(
                              padding: EdgeInsets.all(8.0.r),
                              child: Row(
                                mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                children: [
                                  Text(
                                    'POINTS_DISCOUNT'.tr,
                                    style: fontRegularLite,
                                  ),
                                  Row(
                                    children: [
                                      if (splashController.configData
                                              .siteCurrencyPosition ==
                                          5)
                                        Text(
                                          splashController.configData
                                                  .siteDefaultCurrencySymbol ??
                                              "",
                                          style: fontRegularLite,
                                        ),
                                      Text(
                                        checkoutController.pointsModel.value
                                            .data!.pointDiscountAmount!
                                            .toStringAsFixed(int.parse(
                                                splashController.configData
                                                        .siteDigitAfterDecimalPoint ??
                                                    "2")),
                                        style: fontRegularLite,
                                      ),
                                      if (splashController.configData
                                              .siteCurrencyPosition ==
                                          10)
                                        Text(
                                          splashController.configData
                                                  .siteDefaultCurrencySymbol ??
                                              "",
                                          style: fontRegularLite,
                                        ),
                                    ],
                                  ),
                                ],
                              ),
                            )
                          : const SizedBox(),
                    ),
                    Obx(
                      () => checkoutController.selectedTipIndex.value == -1 ||
                              checkoutController
                                      .tipsModel
                                      .value
                                      .data![checkoutController
                                          .selectedTipIndex.value]
                                      .convertAmount ==
                                  0 ||
                              checkoutController.selectPaymentMethod.value ==
                                  0 ||
                              cartController.orderTypeIndex == 1
                          ? const SizedBox()
                          : Padding(
                              padding: EdgeInsets.all(8.0.r),
                              child: Row(
                                mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                children: [
                                  Text(
                                    'RIDER_TIPS'.tr,
                                    style: fontRegularLite,
                                  ),
                                  Row(
                                    children: [
                                      if (splashController.configData
                                              .siteCurrencyPosition ==
                                          5)
                                        Text(
                                          splashController.configData
                                                  .siteDefaultCurrencySymbol ??
                                              "",
                                          style: fontRegularLite,
                                        ),
                                      Text(
                                        checkoutController
                                            .tipsModel
                                            .value
                                            .data![checkoutController
                                                .selectedTipIndex.value]
                                            .convertAmount!
                                            .toStringAsFixed(int.parse(
                                                splashController.configData
                                                        .siteDigitAfterDecimalPoint ??
                                                    "2")),
                                        style: fontRegularLite,
                                      ),
                                      if (splashController.configData
                                              .siteCurrencyPosition ==
                                          10)
                                        Text(
                                          splashController.configData
                                                  .siteDefaultCurrencySymbol ??
                                              "",
                                          style: fontRegularLite,
                                        ),
                                    ],
                                  ),
                                ],
                              ),
                            ),
                    ),
                    if (cartController.orderTypeIndex == 0 &&
                            cartController.orderTypeIndex != 10 &&
                            cartController.orderTypeIndex != 1 &&
                            Get.find<AddressController>()
                                .addressDataList
                                .isNotEmpty

                        //      &&
                        // addressController.selectedAddress != null

                        )
                      Padding(
                        padding: EdgeInsets.all(8.0.r),
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Text(
                              'DELIVERY_CHARGE'.tr,
                              style: fontRegularLite,
                            ),
                            addressController.checkoutAddressIndex == -1
                                ? Text(
                                    0.toStringAsFixed(int.parse(splashController
                                            .configData
                                            .siteDigitAfterDecimalPoint ??
                                        "2")),
                                    style: fontRegularBoldGreen,
                                  )
                                : Row(
                                    children: [
                                      if (splashController.configData
                                              .siteCurrencyPosition ==
                                          5)
                                        Text(
                                          splashController.configData
                                                  .siteDefaultCurrencySymbol ??
                                              "",
                                          style: fontRegularLite,
                                        ),
                                      Obx(
                                        () => checkoutController
                                                    .distanceModel
                                                    .value
                                                    .data
                                                    ?.convertMinimumOrderAmount ==
                                                null
                                            ? Text(
                                                cartController.deliveryCharge
                                                    .toStringAsFixed(int.parse(
                                                        splashController
                                                                .configData
                                                                .siteDigitAfterDecimalPoint ??
                                                            "2")),
                                                style: fontRegularBoldGreen,
                                              )
                                            : Text(
                                                double.parse(checkoutController
                                                            .distanceModel
                                                            .value
                                                            .data!
                                                            .flatDeliveryCharge ??
                                                        "")
                                                    .toStringAsFixed(int.parse(
                                                        splashController
                                                                .configData
                                                                .siteDigitAfterDecimalPoint ??
                                                            "2")),
                                                style: fontRegularBoldGreen,
                                              ),
                                      ),
                                      if (splashController.configData
                                              .siteCurrencyPosition ==
                                          10)
                                        Text(
                                          splashController.configData
                                                  .siteDefaultCurrencySymbol ??
                                              "",
                                          style: fontRegularLite,
                                        ),
                                    ],
                                  ),
                          ],
                        ),
                      ),
                    Text(
                      '- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -',
                      style: TextStyle(color: AppColor.gray.withOpacity(0.2)),
                      maxLines: 1,
                      overflow: TextOverflow.fade,
                    ),
                    Padding(
                      padding: EdgeInsets.all(8.0.r),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Text(
                            'TOTAL'.tr,
                            style: fontMediumPro,
                          ),
                          Row(
                            children: [
                              if (splashController
                                      .configData.siteCurrencyPosition ==
                                  5)
                                Text(
                                  splashController.configData
                                          .siteDefaultCurrencySymbol ??
                                      "",
                                  style: fontMediumPro,
                                ),
                              Text(
                                (double.parse(cartController.total.toString()))
                                    .toStringAsFixed(int.parse(splashController
                                            .configData
                                            .siteDigitAfterDecimalPoint ??
                                        "2")),
                                style: fontMediumPro,
                              ),
                              if (splashController
                                      .configData.siteCurrencyPosition ==
                                  10)
                                Text(
                                  splashController.configData
                                          .siteDefaultCurrencySymbol ??
                                      "",
                                  style: fontMediumPro,
                                ),
                            ],
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
            ),
          ],
        ),
      ),
    ),
  );
}
