// To parse this JSON data, do
//
//     final tipModel = tipModelFromJson(jsonString);

import 'dart:convert';

TipModel tipModelFromJson(String str) => TipModel.fromJson(json.decode(str));

String tipModelToJson(TipModel data) => json.encode(data.toJson());

class TipModel {
  final List<Datum>? data;

  TipModel({
    this.data,
  });

  factory TipModel.fromJson(Map<String, dynamic> json) => TipModel(
        data: json["data"] == null
            ? []
            : List<Datum>.from(json["data"]!.map((x) => Datum.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class Datum {
  final int? id;
  final String? label;
  final String? amount;
  final int? convertAmount;
  final String? flatAmount;
  final String? currencyAmount;

  Datum({
    this.id,
    this.label,
    this.amount,
    this.convertAmount,
    this.flatAmount,
    this.currencyAmount,
  });

  factory Datum.fromJson(Map<String, dynamic> json) => Datum(
        id: json["id"],
        label: json["label"],
        amount: json["amount"],
        convertAmount: json["convert_amount"],
        flatAmount: json["flat_amount"],
        currencyAmount: json["currency_amount"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "label": label,
        "amount": amount,
        "convert_amount": convertAmount,
        "flat_amount": flatAmount,
        "currency_amount": currencyAmount,
      };
}
