// To parse this JSON data, do
//
//     final pointsModel = pointsModelFromJson(jsonString);

import 'dart:convert';

PointsModel pointsModelFromJson(String str) =>
    PointsModel.fromJson(json.decode(str));

String pointsModelToJson(PointsModel data) => json.encode(data.toJson());

class PointsModel {
  final Data? data;

  PointsModel({
    this.data,
  });

  factory PointsModel.fromJson(Map<String, dynamic> json) => PointsModel(
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "data": data?.toJson(),
      };
}

class Data {
  final int? points;
  final bool? isPointApplicable;
  final int? userPoints;
  final int? applicablePoints;
  final dynamic pointDiscountAmount;
  final String? currencyPointDiscountAmount;

  Data({
    this.points,
    this.isPointApplicable,
    this.userPoints,
    this.applicablePoints,
    this.pointDiscountAmount,
    this.currencyPointDiscountAmount,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        points: json["points"],
        isPointApplicable: json["is_point_applicable"],
        userPoints: json["user_points"],
        applicablePoints: json["applicable_points"],
        pointDiscountAmount: json["point_discount_amount"],
        currencyPointDiscountAmount: json["currency_point_discount_amount"],
      );

  Map<String, dynamic> toJson() => {
        "points": points,
        "is_point_applicable": isPointApplicable,
        "user_points": userPoints,
        "applicable_points": applicablePoints,
        "point_discount_amount": pointDiscountAmount,
        "currency_point_discount_amount": currencyPointDiscountAmount,
      };
}
