// To parse this JSON data, do
//
//     final distanceCheckModel = distanceCheckModelFromJson(jsonString);

import 'dart:convert';

DistanceCheckModel distanceCheckModelFromJson(String str) =>
    DistanceCheckModel.fromJson(json.decode(str));

String distanceCheckModelToJson(DistanceCheckModel data) =>
    json.encode(data.toJson());

class DistanceCheckModel {
  final Data? data;

  DistanceCheckModel({
    this.data,
  });

  factory DistanceCheckModel.fromJson(Map<String, dynamic> json) =>
      DistanceCheckModel(
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "data": data?.toJson(),
      };
}

class Data {
  final int? id;
  final int? branchId;
  final String? kilometerRange;
  final String? minimumOrderAmount;
  final String? deliveryCharge;
  final String? flatMinimumOrderAmount;
  final int? convertMinimumOrderAmount;
  final String? currencyMinimumOrderAmount;
  final String? flatDeliveryCharge;
  final int? convertDeliveryCharge;
  final String? currencyDeliveryCharge;

  Data({
    this.id,
    this.branchId,
    this.kilometerRange,
    this.minimumOrderAmount,
    this.deliveryCharge,
    this.flatMinimumOrderAmount,
    this.convertMinimumOrderAmount,
    this.currencyMinimumOrderAmount,
    this.flatDeliveryCharge,
    this.convertDeliveryCharge,
    this.currencyDeliveryCharge,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        id: json["id"],
        branchId: json["branch_id"],
        kilometerRange: json["kilometer_range"],
        minimumOrderAmount: json["minimum_order_amount"],
        deliveryCharge: json["delivery_charge"],
        flatMinimumOrderAmount: json["flat_minimum_order_amount"],
        convertMinimumOrderAmount: json["convert_minimum_order_amount"],
        currencyMinimumOrderAmount: json["currency_minimum_order_amount"],
        flatDeliveryCharge: json["flat_delivery_charge"],
        convertDeliveryCharge: json["convert_delivery_charge"],
        currencyDeliveryCharge: json["currency_delivery_charge"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "branch_id": branchId,
        "kilometer_range": kilometerRange,
        "minimum_order_amount": minimumOrderAmount,
        "delivery_charge": deliveryCharge,
        "flat_minimum_order_amount": flatMinimumOrderAmount,
        "convert_minimum_order_amount": convertMinimumOrderAmount,
        "currency_minimum_order_amount": currencyMinimumOrderAmount,
        "flat_delivery_charge": flatDeliveryCharge,
        "convert_delivery_charge": convertDeliveryCharge,
        "currency_delivery_charge": currencyDeliveryCharge,
      };
}
