import 'dart:convert';

import 'package:get/get.dart';
import '../../../../util/api-list.dart';
import '../../../../util/constant.dart';
import '../../../../widget/custom_snackbar.dart';
import '../../../data/api/server.dart';
import '../../../data/model/response/order_details_model.dart';
import '../../address/controllers/address_controller.dart';
import '../../cart/controllers/cart_controller.dart';
import '../../home/controllers/home_controller.dart';
import '../../payment/views/payment_view.dart';

class PlaceOrderController extends GetxController {
  static Server server = Server();
  OrderDetailsModel orderDetailsModel = OrderDetailsModel();
  OrderDetailsData orderDetailsData = OrderDetailsData();
  bool loader = false;

  @override
  // ignore: unnecessary_overrides
  void onInit() {
    super.onInit();
  }

  Future<OrderDetailsModel> placeOrderPost(placeOrderModel,
      {String? paymentSlug}) async {
    loader = true;
    update();
    Map body = {
      "branch_id": placeOrderModel.branchId,
      "order_type": placeOrderModel.orderType,
      "is_advance_order": placeOrderModel.isAdvanceOrder,
      "address_id": placeOrderModel.addressId,
      "delivery_time": placeOrderModel.deliveryTime,
      "subtotal": placeOrderModel.subtotal,
      "delivery_charge": placeOrderModel.deliveryCharge,
      "rider_tip": placeOrderModel.riderTip,
      "discount": placeOrderModel.discount,
      "total": placeOrderModel.total,
      "coupon_id": placeOrderModel.couponId,
      "source": 10,
      "point_discount_amount": placeOrderModel.pointsAmount,
      "items": json.encode(placeOrderModel.items).toString(),
    };
    String jsonBody = json.encode(body);
    server
        .postRequestWithToken(endPoint: APIList.order, body: jsonBody)
        .then((response) {
      print("Place Order POST - ${response.body}");
      if (response != null && response.statusCode == 201) {
        loader = false;
        update();
        Get.find<CartController>().cart.clear();
        final jsonResponse = json.decode(response.body);
        orderDetailsModel = OrderDetailsModel.fromJson(jsonResponse);
        orderDetailsData = orderDetailsModel.data!;
        Get.find<HomeController>().getActiveOrderList();

        update();

        Get.to(() => PaymentView(
              orderId: orderDetailsData.id,
              paymentSlug: paymentSlug,
            ));

        // Future.delayed(Duration(seconds: 2), () {
        //   callback(true, orderDetailsData);
        // });

        // reset all addresses index
        Get.find<CartController>().removeCoupon();
        Get.find<AddressController>().resetAddressState();
      } else {
        final jsonResponse = json.decode(response.body);
        customSnackbar("ERROR".tr, jsonResponse["message"], AppColor.error);
        update();
        Future.delayed(const Duration(milliseconds: 1000), () {
          loader = false;
          update();
        });
      }
    });
    update();
    return orderDetailsModel;
  }
}
