import 'package:foodking/app/data/repository/checkout_repo.dart';
import 'package:foodking/app/modules/checkout/model/points_model.dart';
import 'package:foodking/app/modules/checkout/model/tip_model.dart';
import 'package:foodking/util/constant.dart';
import 'package:foodking/widget/custom_snackbar.dart';
import 'package:get/get.dart';

import '../../../../util/api-list.dart';
import '../../../data/api/server.dart';
import '../../../data/model/response/time_slot_model.dart';
import '../../../data/repository/time_slot_repo.dart';
import '../model/distance_check_model.dart';
import '../model/payment_model.dart';

class CheckoutController extends GetxController {
  bool couponApplied = false;

  final _checkoutRepo = CheckoutRepo();
  int selectDateSlot = 0;
  int selectTimeSlot = 0;
  final selectPaymentMethod = Rx(-1);
  final paymentModel = PaymentModel().obs;
  final pointsModel = PointsModel().obs;
  final tipsModel = TipModel().obs;
  int? paymentMethodId;
  String paymentMethodSlug = "";
  final isPointApply = false.obs;
  final selectedTipIndex = RxInt(-1);
  String selectedDate = '';
  bool isStatus = false;

  List<TimeSlotData> todayDataList = <TimeSlotData>[];
  List<TimeSlotData> tomorrowDataList = <TimeSlotData>[];
  final distanceModel = DistanceCheckModel().obs;
  Future<void> getPaymentGateways() async {
    final data = await _checkoutRepo.getPaymentGateways();
    data.fold((error) {}, (data) {
      paymentModel.value = data;
    });
  }

  Future<void> getPoints() async {
    print("Point called");
    final result = await _checkoutRepo.getPoints();
    print("poinst result = $result");
    result.fold((error) => error, (data) {
      pointsModel.value = data;
    });
  }

  Future<void> getTips() async {
    final data = await _checkoutRepo.getTips();
    data.fold((error) => error, (data) {
      tipsModel.value = data;
    });
  }

  getTodayTime({required String branchID}) async {
    var todayData = await TimeSlotRepo.getTodayTimeSlot(branchID: branchID);
    if (todayData != null) {
      todayDataList = todayData.data!;
      selectedDate = todayDataList[0].time ?? "";
      update();
    }
    update();
  }

  getTomorrowTime({required String branchID}) async {
    var tomorrowData =
        await TimeSlotRepo.getTomorrowTimeSlot(branchID: branchID);
    if (tomorrowData != null) {
      tomorrowDataList = tomorrowData.data!;
      update();
    }
    update();
  }

  void updateDateSlot(int index) {
    selectDateSlot = index;
    update();
  }

  void updateTimeSlot(int index) {
    selectTimeSlot = index;
    update();
  }

  static Future<bool> checkoutAddressZoneChecker(
      {required double latitude, required double longitude}) async {
    try {
      // await box.remove('isCheckoutZone');
      final response = await Server().getRequestWithoutToken(
        endPoint: APIList.branchByLatLong(lat: latitude, long: longitude),
      );

      if (response != null && response.statusCode == 200) {
        // final jsonResponse = jsonDecode(response.body);

        print("CheckoutZone response = ${response.body}");
        // await box.write('isCheckoutZone', true);

        return true;
      } else {
        return false;
      }
    } catch (e) {
      return false;
    }
  }

  Future<void> checkDistance(
      {required String branchId,
      required String distance,
      required String latitude,
      required String longitude}) async {
    final result = await _checkoutRepo.getDistanceCheck(
        branchId: branchId,
        distance: distance,
        latitude: latitude,
        longitude: longitude);

    print("CheckDistanceResult = $result");
    result.fold((error) {
      customSnackbar("ERROR".tr, error, AppColor.redColor);
      isStatus = false;
      print("IsSTATUS = $isStatus");
    }, (data) {
      print("CheckDistance Result = $result");
      distanceModel.value = data;
      isStatus = true;
      print("IsSTATUS = $isStatus");
    });
  }
}
