import 'dart:convert';
import '../../../util/api-list.dart';
import '../api/server.dart';
import '../model/response/time_slot_model.dart';

class TimeSlotRepo {
  static Server server = Server();
  static TimeSlotModel todayTimeSlotModelData = TimeSlotModel();
  static TimeSlotModel tomorrowTimeSlotModelData = TimeSlotModel();

  static Future<TimeSlotModel?> getTodayTimeSlot(
      {required String branchID}) async {
    try {
      await server
          .getRequestWithoutToken(
        endPoint: APIList.todayTimeSlot(branchID: branchID),
      )
          .then((response) {
        if (response != null && response.statusCode == 200) {
          final jsonResponse = json.decode(response.body);
          todayTimeSlotModelData = TimeSlotModel.fromJson(jsonResponse);
          return todayTimeSlotModelData;
        }
      });
      return todayTimeSlotModelData;
    } catch (e) {
      return null;
    }
  }

  static Future<TimeSlotModel?> getTomorrowTimeSlot(
      {required String branchID}) async {
    try {
      await server
          .getRequestWithoutToken(
        endPoint: APIList.tomorrowTimeSlot(branchID: branchID),
      )
          .then((response) {
        if (response != null && response.statusCode == 200) {
          final jsonResponse = json.decode(response.body);
          tomorrowTimeSlotModelData = TimeSlotModel.fromJson(jsonResponse);
          return tomorrowTimeSlotModelData;
        }
      });
      return tomorrowTimeSlotModelData;
    } catch (e) {
      return null;
    }
  }
}
