// ignore_for_file: prefer_interpolation_to_compose_strings

import 'dart:convert';
import 'package:dartz/dartz.dart';

import '../../../util/api-list.dart';
import '../api/server.dart';
import '../model/response/item_model.dart';

class FeaturedItemRepo {
  static Server server = Server();

  static Future<Either<String, ItemModel>> getFeaturedItem({
    required String branchId,
  }) async {
    try {
      final response = await server.getRequestWithoutToken(
        endPoint: APIList.featuredItems(branchId: branchId),
      );

      // Fix typo: statuScode -> statusCode
      if (response.statusCode == 200) {
        final data = jsonDecode(response.body);
        print('featured data');
        print(data);
        return Right(ItemModel.fromJson(data));
      } else {
        return Left(response.body); // Return error body if not 200
      }
    } catch (e) {
      return Left(e.toString());
    }
  }
}
