import 'dart:convert';

import 'package:dartz/dartz.dart';
import 'package:foodking/app/modules/checkout/model/points_model.dart';
import 'package:foodking/app/modules/checkout/model/tip_model.dart';
import 'package:foodking/util/api-list.dart';
import '../../modules/checkout/model/distance_check_model.dart';
import '../../modules/checkout/model/payment_model.dart';
import '../api/server.dart';

class CheckoutRepo {
  Future<Either<String, PaymentModel>> getPaymentGateways() async {
    try {
      final response =
          await Server().getRequest(endPoint: APIList.paymentGateway);
      if (response.statusCode == 200) {
        final data = jsonDecode(response.body);
        return Right(PaymentModel.fromJson(data));
      } else {
        return Left(response.data);
      }
    } catch (e) {
      return Left(e.toString());
    }
  }

  Future<Either<String, PointsModel>> getPoints() async {
    try {
      final response = await Server().getRequest(endPoint: APIList.points);
      print("point response = ${response.body}");
      if (response.statusCode == 200) {
        final data = jsonDecode(response.body);
        return Right(PointsModel.fromJson(data));
      } else {
        return Left(response.data);
      }
    } catch (e) {
      return Left(e.toString());
    }
  }

  Future<Either<String, TipModel>> getTips() async {
    try {
      final response = await Server().getRequest(endPoint: APIList.tips);

      if (response.statusCode == 200) {
        final data = jsonDecode(response.body);
        return Right(TipModel.fromJson(data));
      } else {
        return Left(response.data);
      }
    } catch (e) {
      return Left(e.toString());
    }
  }

  Future<Either<String, DistanceCheckModel>> getDistanceCheck(
      {required String branchId,
      required String distance,
      required String latitude,
      required String longitude}) async {
    try {
      final response = await Server().getRequest(
          endPoint: APIList.distanceCheck(
              branchId: branchId,
              distance: distance,
              latitude: double.parse(latitude),
              longitude: double.parse(longitude)));

      print("check BranchId = $branchId");
      print("check distance = $distance");
      print("check lat = $latitude");
      print("check long = $longitude");

      print("CheckDistance = ${response.body}");
      print("================== ${jsonDecode(response.body)["message"]}");

      if (response.statusCode == 200) {
        final data = jsonDecode(response.body);
        print("CheckDistance = ${response.body}");

        return Right(DistanceCheckModel.fromJson(data));
      } else {
        return Left(jsonDecode(response.body)["message"]);
      }
    } catch (e) {
      return Left(e.toString());
    }
  }
}
