// ignore_for_file: prefer_interpolation_to_compose_strings

import 'dart:convert';
import 'package:dartz/dartz.dart';
import 'package:foodking/app/modules/address/controllers/address_controller.dart';
import 'package:foodking/app/modules/cart/controllers/cart_controller.dart';
import 'package:foodking/main.dart';
import 'package:get/get.dart';
import '../../../util/api-list.dart';
import '../api/server.dart';
import '../model/response/branch_model.dart';

class BranchRepo {
  final addressController = Get.find<AddressController>();
  static Server server = Server();
  static BranchModel branchModelData = BranchModel();
  static BranchData branchData = BranchData();

  static Future<Either<String, BranchData>> getBranchByLatLong(
      {required double latitude, required double longitude}) async {
    try {
      await box.write('isZoneFound', false);
      // Retrieve the existing branch name before removing it
      String? currentBranchName = box.read("branchName").toString();
      // int? currentBrancId = box.read("branchId");
      final response = await server.getRequestWithoutToken(
        endPoint: APIList.branchByLatLong(lat: latitude, long: longitude),
      );

      if (response != null && response.statusCode == 200) {
        final jsonResponse = jsonDecode(response.body);

        print("BranchResponse = ${response.body}");

        box.remove('currentBranchId');
        box.remove('currentBranchName');

        // Retrieve new branch information
        String newBranchName = jsonResponse["data"]["name"].toString();
        box.write('currentBranchName', jsonResponse["data"]["name"].toString());
        int newBranchId = jsonResponse["data"]["id"];

        box.write('currentBranchId', jsonResponse["data"]["id"]);

        // Set cartReset based on branch name change
        if (box.read("branchName") == null) {
          await box.write("branchName", newBranchName);
          await box.write("branchId", newBranchId);
        } else if (currentBranchName == newBranchName) {
          await box.write("cartReset", false);

          print("CARTRESET IS FALSE");
        } else if (currentBranchName != newBranchName) {
          await box.write("prevBranchName", currentBranchName);

          await box.write("cartReset", true);
          print("CARTRESET IS TRUE");
        } else if (currentBranchName != newBranchName &&
            Get.find<CartController>().cart.isNotEmpty) {
          await box.write("prevBranchName", currentBranchName);

          await box.remove("branchName");
          await box.remove("branchId");

          await box.write("branchName", box.read('currentBranchName'));
          await box.write("branchId", box.read('currentBranchId'));

          await box.write("cartReset", true);
          print("CARTRESET IS TRUE");
        } else if (currentBranchName != newBranchName &&
            Get.find<CartController>().cart.length < 0) {
          await box.write("prevBranchName", currentBranchName);

          await box.remove("branchName");
          await box.remove("branchId");

          await box.write("branchName", box.read('currentBranchName'));
          await box.write("branchId", box.read('currentBranchId'));

          await box.write("cartReset", true);
          print("CARTRESET IS TRUE");
        }

        await box.write("isZoneFound", true);

        return Right(BranchData.fromJson(jsonResponse["data"]));
      } else {
        return Left(jsonDecode(response.body)["message"]);
      }
    } catch (e) {
      return Left(e.toString());
    }
  }
}
