if (stripeKey) {
    var stripe = Stripe(stripeKey);
    var cardElements = stripe.elements();
    var style = {
        base: {
            fontSize: '16px',
            color: '#32325d',
            border: '1px solid red',
        },
    };

    var card = cardElements.create('card', { style: style });
    card.mount('#card-element');

    function stripe_payment() {
        $('#payment_method').parent().removeClass('has-error');
        stripe.createToken(card).then(function (result) {
            if (result.error) {
                let errorElement = document.getElementById('card-errors');
                errorElement.textContent = result.error.message;
            } else {
                stripeTokenHandler(result.token);
            }
        });

    }

    function stripeTokenHandler(token) {
        let form = document.getElementById('paymentForm');
        let hiddenInput = document.createElement('input');
        hiddenInput.setAttribute('type', 'hidden');
        hiddenInput.setAttribute('name', 'stripeToken');
        hiddenInput.setAttribute('value', token.id);
        form.appendChild(hiddenInput);
        form.submit();
    }


    //Express Checkout start

    const orderData = {
        mode: 'payment',
        amount: stripeTotalAmount * 100,
        currency: stripeCurrencyCode.toLowerCase(),
    };

    const expressCheckoutOptions = {
        paymentMethods: {
            card: 'always',
            applePay: 'always',
            googlePay: 'always',
            link: 'auto'
        },
        paymentMethodOrder: ['card', 'googlePay', 'applePay', 'link'],
        buttonType: {
            applePay: 'buy',
            googlePay: 'order',
        },
        layout: {
            maxColumns: 0,
            maxRows: 0,
            overflow: 'never'
        }
    };
    const elements = stripe.elements({
        locale: 'en',
        mode: 'payment',
        amount: stripeTotalAmount * 100,
        currency: stripeCurrencyCode.toLowerCase(),
    });
    const expressCheckoutElement = elements.create(
        'expressCheckout',
        expressCheckoutOptions
    )
    expressCheckoutElement.mount("#express-checkout-element");
    expressCheckoutElement.on('click', (event) => {
        const options = {
            emailRequired: true
        };
        event.resolve(options);
    });


    expressCheckoutElement.on('confirm', (event) => {
        fetch(stripeExpressPayLink,
            {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    order: orderData,
                    paymentMethod: 'stripe',
                    stripeToken: 'express'
                })
            })

            .then(function (response) {
                responseClone = response.clone();
                return response.json();
            })
            .then(function (paymentIntent) {
                const clientSecret = paymentIntent.clientSecret;
                const { error } = stripe.confirmPayment({
                    elements,
                    clientSecret,
                    confirmParams: {
                        return_url: stripeSuccessLink,
                    },
                });
            }, function (rejectionReason) {
               // console.log('Error parsing JSON from response:', rejectionReason, responseClone); // 4
                responseClone.text()
                    .then(function (bodyText) {
                       // console.log('Received the following instead of valid JSON:', bodyText); // 6
                    });
            });
    });

}
